/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.block;

import javax.annotation.Nullable;
import net.mcreator.redev.block.entity.TallUrnBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class TallUrnBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public TallUrnBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASEDRUM).m_60918_(SoundType.f_154680_).m_60978_(2.0f).m_60999_().m_60955_().m_60924_((bs, br, bp) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        if (half == DoubleBlockHalf.UPPER) {
            return Shapes.m_83110_((VoxelShape)TallUrnBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), (VoxelShape)TallUrnBlock.m_49796_((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
        }
        return Shapes.m_83110_((VoxelShape)TallUrnBlock.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape)TallUrnBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, HALF});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean waterlogged;
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        boolean bl = waterlogged = level.m_6425_(pos).m_76152_() == Fluids.f_76193_;
        if (pos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(pos.m_7494_()).m_60629_(context)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockPos upper = pos.m_7494_();
        level.m_7731_(upper, TallUrnBlock.copyWaterloggedFrom((LevelReader)level, upper, (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)), 3);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        boolean matchingHalf;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        boolean bl = matchingHalf = facingState.m_60713_((Block)this) && facingState.m_61143_(HALF) != half;
        if (facing.m_122434_() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (facing == Direction.UP) || matchingHalf) {
            return half == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.m_60710_((LevelReader)world, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
        }
        return Blocks.f_50016_.m_49966_();
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        BlockState belowState = world.m_8055_(below);
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? belowState.m_60783_((BlockGetter)world, below, Direction.UP) : belowState.m_60713_((Block)this);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            if (player.m_7500_()) {
                TallUrnBlock.preventCreativeDropFromBottomPart(level, pos, state, player);
            } else {
                TallUrnBlock.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity be, ItemStack stack) {
        super.m_6240_(level, player, pos, Blocks.f_50016_.m_49966_(), be, stack);
    }

    public static void preventCreativeDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos below;
        BlockState belowState;
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER && (belowState = level.m_8055_(below = pos.m_7495_())).m_60713_(state.m_60734_()) && belowState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState replacement = belowState.m_61138_((Property)WATERLOGGED) && (Boolean)belowState.m_61143_((Property)WATERLOGGED) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(below, replacement, 35);
            level.m_5898_(player, 2001, below, Block.m_49956_((BlockState)belowState));
        }
    }

    public static BlockState copyWaterloggedFrom(LevelReader level, BlockPos pos, BlockState state) {
        return state.m_61138_((Property)WATERLOGGED) ? (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_46801_(pos))) : state;
    }

    public static void placeAt(LevelAccessor world, BlockState state, BlockPos pos, int flags) {
        BlockPos above = pos.m_7494_();
        world.m_7731_(pos, TallUrnBlock.copyWaterloggedFrom((LevelReader)world, pos, (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)), flags);
        world.m_7731_(above, TallUrnBlock.copyWaterloggedFrom((LevelReader)world, above, (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)), flags);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity be;
            DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
            if (half == DoubleBlockHalf.LOWER && (be = world.m_7702_(pos)) instanceof TallUrnBlockEntity) {
                TallUrnBlockEntity urn = (TallUrnBlockEntity)be;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)urn);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockPos basePos;
        BlockEntity be;
        if (!level.f_46443_ && (be = level.m_7702_(basePos = state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos)) instanceof MenuProvider) {
            MenuProvider provider = (MenuProvider)be;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (BlockPos)basePos);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TallUrnBlockEntity(pos, state);
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
        super.m_8133_(state, level, pos, id, param);
        BlockEntity be = level.m_7702_(pos);
        return be != null && be.m_7531_(id, param);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        int n;
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof TallUrnBlockEntity) {
            TallUrnBlockEntity urn = (TallUrnBlockEntity)be;
            n = AbstractContainerMenu.m_38938_((Container)urn);
        } else {
            n = 0;
        }
        return n;
    }

    public MenuProvider m_7246_(BlockState state, Level world, BlockPos pos) {
        MenuProvider menuProvider;
        BlockPos basePos = state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos;
        BlockEntity be = world.m_7702_(basePos);
        return be instanceof MenuProvider ? (menuProvider = (MenuProvider)be) : null;
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_6625_(state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)pos.m_123343_());
    }
}

