/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.redev.entity.CopperGolemEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelcopper_golem<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("redev", "modelcopper_golem"), "main");
    public final ModelPart root;
    public final ModelPart head;
    public final ModelPart body;
    public final ModelPart left_arm;
    public final ModelPart right_arm;
    public final ModelPart left_leg;
    public final ModelPart right_leg;

    public Modelcopper_golem(ModelPart root) {
        this.root = root.m_171324_("root");
        this.head = this.root.m_171324_("head");
        this.body = this.root.m_171324_("body");
        this.left_arm = this.root.m_171324_("left_arm");
        this.right_arm = this.root.m_171324_("right_arm");
        this.left_leg = this.root.m_171324_("left_leg");
        this.right_leg = this.root.m_171324_("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(39, 0).m_171488_(-2.0f, -4.0f, -7.5f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-7.0f, -9.0f, -5.5f, 14.0f, 9.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(38, 28).m_171488_(-1.0f, -11.5f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(38, 20).m_171488_(-2.0f, -15.5f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-6.0f, 0.0f, -3.5f, 12.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition left_arm = root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(20, 34).m_171480_().m_171488_(0.0f, -2.0f, -2.5f, 4.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)6.0f, (float)-10.0f, (float)0.0f));
        PartDefinition right_arm = root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(20, 34).m_171488_(-4.0f, -2.0f, -2.5f, 4.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)-10.0f, (float)0.0f));
        PartDefinition left_leg = root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171480_().m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)3.5f, (float)-5.0f, (float)0.0f));
        PartDefinition right_leg = root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.5f, (float)-5.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof CopperGolemEntity) {
            CopperGolemEntity golem = (CopperGolemEntity)((Object)entity);
            float oxidizationSpeedArms = 3.0f + 3.0f * (0.2f * (float)(golem.getOxidizationLevel() - 1));
            float oxidizationSpeedHead = 40 + 20 * (golem.getOxidizationLevel() - 1);
            this.head.f_104204_ = golem.getOxidizationLevel() < 4 && golem.getTotalRotationDuration() > 0 ? (float)(Math.PI * 2 * (double)(ageInTicks % oxidizationSpeedHead) / (double)oxidizationSpeedHead) : netHeadYaw / 57.295776f;
            this.head.f_104203_ = headPitch / 57.295776f;
            if (golem.getIsInteracting() > 0) {
                this.right_arm.f_104203_ = -1.5707964f;
                this.left_arm.f_104203_ = -1.5707964f;
                float oscillation = (float)Math.sin(ageInTicks / oxidizationSpeedArms) * (float)Math.PI / 4.0f;
                this.right_arm.f_104203_ += oscillation;
                this.left_arm.f_104203_ -= oscillation;
            } else {
                this.right_arm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
                this.left_arm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
            }
        }
        this.right_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.left_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.root.f_104205_ = Mth.m_14031_((float)(limbSwing * 0.6662f)) * 0.15f * limbSwingAmount;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

