/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DrawbackEnchantment
extends Enchantment {
    public DrawbackEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.WEAPON, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 2;
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemstack) {
        return Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("redev:sickles"))).test(itemstack);
    }

    @SubscribeEvent
    public void onEntityHit(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        LivingEntity target = event.getEntity();
        ItemStack weapon = player.m_21205_();
        int level = weapon.getEnchantmentLevel((Enchantment)this);
        if (level > 0) {
            double dz;
            double knockbackStrength = 0.6 * (double)level;
            double dx = player.m_20185_() - target.m_20185_();
            double distance = Math.sqrt(dx * dx + (dz = player.m_20189_() - target.m_20189_()) * dz);
            if (distance > 0.0) {
                double pullFactor = knockbackStrength;
                target.m_20334_(target.m_20184_().f_82479_ + dx / distance * pullFactor, target.m_20184_().f_82480_, target.m_20184_().f_82481_ + dz / distance * pullFactor);
                target.f_19812_ = true;
            }
        }
    }
}

