/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.List;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FleeEnchantment
extends Enchantment {
    private static final UUID MOVEMENT_SPEED_MODIFIER = UUID.fromString("5e1246fa-3d9f-4bda-b72b-fcbbde5a10e2");

    public FleeEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.ARMOR_FEET, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    public boolean m_6591_() {
        return true;
    }

    protected boolean m_5975_(Enchantment ench) {
        return this != ench && !List.of(Enchantments.f_44967_, Enchantments.f_44973_, Enchantments.f_44972_).contains(ench);
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        int level = player.m_6844_(EquipmentSlot.FEET).getEnchantmentLevel((Enchantment)this);
        if (level > 0) {
            double activationThreshold;
            double maxHealth = player.m_21233_();
            double currentHealth = player.m_21223_();
            if (currentHealth <= (activationThreshold = maxHealth * (0.5 + 0.1 * (double)level))) {
                double missingHealthRatio = (activationThreshold - currentHealth) / activationThreshold;
                double speedBonus = missingHealthRatio * (0.05 * (double)level);
                this.applyMovementSpeedBoost(player, speedBonus);
            } else {
                this.removeMovementSpeedBoost(player);
            }
        } else {
            this.removeMovementSpeedBoost(player);
        }
    }

    private void applyMovementSpeedBoost(Player player, double amount) {
        AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22279_);
        if (attributeInstance == null) {
            return;
        }
        attributeInstance.m_22120_(MOVEMENT_SPEED_MODIFIER);
        attributeInstance.m_22118_(new AttributeModifier(MOVEMENT_SPEED_MODIFIER, "Flee speed boost", amount, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    private void removeMovementSpeedBoost(Player player) {
        AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22279_);
        if (attributeInstance != null) {
            attributeInstance.m_22120_(MOVEMENT_SPEED_MODIFIER);
        }
    }

    @SubscribeEvent
    public void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSlot() == EquipmentSlot.FEET && (event.getTo() == null || event.getTo().m_41619_() || event.getTo().getEnchantmentLevel((Enchantment)this) == 0)) {
                this.removeMovementSpeedBoost(player);
            }
        }
    }
}

