/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MomentumEnchantment
extends Enchantment {
    private static final HashMap<UUID, Integer> BLOCKS_BROKEN = new HashMap();
    private static final HashMap<UUID, Integer> RESET_TIMER = new HashMap();

    public MomentumEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.DIGGER, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected boolean m_5975_(Enchantment ench) {
        return this != ench && ench != Enchantments.f_44984_;
    }

    public boolean m_6591_() {
        return true;
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player == null || player.m_7500_()) {
            return;
        }
        ItemStack tool = player.m_21205_();
        if (tool.m_41619_()) {
            return;
        }
        int level = EnchantmentHelper.m_44843_((Enchantment)this, (ItemStack)tool);
        if (level > 0) {
            UUID playerUUID = player.m_20148_();
            int blocksBroken = BLOCKS_BROKEN.getOrDefault(playerUUID, 0) + 1;
            BLOCKS_BROKEN.put(playerUUID, blocksBroken);
            RESET_TIMER.put(playerUUID, 50);
            float factor = 1.0f + (float)blocksBroken * 0.25f;
            int durabilityDamage = (int)Math.floor(factor);
            tool.m_41622_(durabilityDamage, (LivingEntity)player, p -> p.m_21190_(event.getPlayer().m_7655_()));
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        int blocksBroken = BLOCKS_BROKEN.getOrDefault(playerUUID, 0);
        if (blocksBroken > 0) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f + (float)blocksBroken * 0.75f));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player == null || player.m_7500_()) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        if (RESET_TIMER.containsKey(playerUUID)) {
            int timeLeft = RESET_TIMER.get(playerUUID) - 1;
            if (timeLeft <= 0) {
                RESET_TIMER.remove(playerUUID);
                BLOCKS_BROKEN.remove(playerUUID);
            } else {
                RESET_TIMER.put(playerUUID, timeLeft);
            }
        }
    }
}

