/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SharedPainEnchantment
extends Enchantment {
    public SharedPainEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.BREAKABLE, new EquipmentSlot[]{EquipmentSlot.OFFHAND, EquipmentSlot.MAINHAND});
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemstack) {
        return itemstack.m_41720_() instanceof ShieldItem;
    }

    public boolean m_6591_() {
        return true;
    }

    public boolean m_6594_() {
        return false;
    }

    @SubscribeEvent
    public void onBlockedAttack(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack shield = player.m_21211_();
        if (!(shield.m_41720_() instanceof ShieldItem) || !player.m_21254_()) {
            return;
        }
        int level = shield.getEnchantmentLevel((Enchantment)this);
        if (level <= 0) {
            return;
        }
        float originalDamage = event.getAmount();
        event.setAmount(0.0f);
        DamageSource attackerSource = event.getSource();
        if (!player.m_9236_().m_5776_()) {
            double radius = 1.5 * (double)level;
            List nearbyMobs = ((ServerLevel)player.m_9236_()).m_6443_(LivingEntity.class, player.m_20191_().m_82400_(radius), entity -> entity != player && entity.m_6084_());
            float sharedDamage = (0.1f + 0.2f * (float)level) * originalDamage;
            for (LivingEntity mob : nearbyMobs) {
                mob.m_6469_(attackerSource, sharedDamage);
            }
        }
        shield.m_41622_((int)originalDamage, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
        if (shield.m_41773_() >= shield.m_41776_()) {
            player.m_21008_(player.m_7655_(), ItemStack.f_41583_);
        }
    }
}

