/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchanterEntity
extends SpellcasterIllager {
    private static final int MAX_STACKS = 3;
    private static final TagKey<EntityType<?>> RAIDERS = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("minecraft", "raiders"));
    private static final TagKey<EntityType<?>> ENCHANTABLES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("redev", "enchantables"));
    private static final EntityDataAccessor<Integer> DATA_ENCHANT_COOLDOWN = SynchedEntityData.m_135353_(EnchanterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public EnchanterEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<EnchanterEntity>)((EntityType)RedevModEntities.ENCHANTER.get()), world);
    }

    public EnchanterEntity(EntityType<EnchanterEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 6;
        this.m_21557_(false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ENCHANT_COOLDOWN, (Object)160);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new EnchanterEnchantGoal());
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
    }

    public MobType m_6336_() {
        return MobType.f_21643_;
    }

    public void m_6075_() {
        super.m_6075_();
        int cooldown = (Integer)this.f_19804_.m_135370_(DATA_ENCHANT_COOLDOWN);
        if (cooldown > 0) {
            this.f_19804_.m_135381_(DATA_ENCHANT_COOLDOWN, (Object)(cooldown - 1));
        }
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:enchanter.idle"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:enchanter.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:enchanter.death"));
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.evoker.celebrate"));
    }

    public SoundEvent m_7894_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:enchanter.casting"));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        return retval;
    }

    public static void init() {
        Raid.RaiderType.create((String)"enchanter", (EntityType)((EntityType)RedevModEntities.ENCHANTER.get()), (int[])new int[]{0, 0, 0, 0, 1, 1, 1, 2});
    }

    public void m_7895_(int num, boolean logic) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.5);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    private class EnchanterEnchantGoal
    extends Goal {
        private int castingTicks;
        private List<Mob> targets;

        private EnchanterEnchantGoal() {
        }

        public boolean m_8036_() {
            if ((Integer)EnchanterEntity.this.f_19804_.m_135370_(DATA_ENCHANT_COOLDOWN) > 0) {
                return false;
            }
            this.targets = EnchanterEntity.this.m_9236_().m_6443_(Mob.class, EnchanterEntity.this.m_20191_().m_82400_(16.0), e -> e != EnchanterEntity.this && (e.m_6095_().m_204039_(RAIDERS) || e.m_6095_().m_204039_(ENCHANTABLES)) && !e.getPersistentData().m_128471_("mobEnchanted"));
            return !this.targets.isEmpty();
        }

        public void m_8056_() {
            this.castingTicks = 40;
            EnchanterEntity.this.m_33727_(SpellcasterIllager.IllagerSpell.SUMMON_VEX);
            EnchanterEntity.this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:enchanter.enchant_spell")), 1.0f, 1.0f);
            for (Mob mob : this.targets) {
                mob.m_21573_().m_5624_((Entity)EnchanterEntity.this, 1.2);
            }
        }

        public void m_8037_() {
            --this.castingTicks;
            if (this.castingTicks > 0) {
                EnchanterEntity.this.m_21573_().m_26573_();
            }
            if (this.castingTicks == 10) {
                this.applyEnchantments();
            }
        }

        public boolean m_8045_() {
            return this.castingTicks > 0;
        }

        public void m_8041_() {
            EnchanterEntity.this.m_33727_(SpellcasterIllager.IllagerSpell.NONE);
            EnchanterEntity.this.f_19804_.m_135381_(DATA_ENCHANT_COOLDOWN, (Object)Mth.m_216271_((RandomSource)EnchanterEntity.this.f_19796_, (int)160, (int)320));
            EnchanterEntity.this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.evoker.cast_spell")), 1.0f, 1.0f);
        }

        private void applyEnchantments() {
            for (Mob mob : this.targets) {
                int roll = EnchanterEntity.this.f_19796_.m_188503_(100);
                if (roll < 50) {
                    this.applyCommonBuff(mob);
                } else if (roll < 80) {
                    this.applyUncommonBuff(mob);
                } else {
                    this.applyRareBuff(mob);
                }
                mob.getPersistentData().m_128379_("mobEnchanted", true);
                mob.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.enchantment_table.use")), 1.0f, 1.0f);
            }
        }

        private void applyCommonBuff(Mob mob) {
            String[] commonBuffs = new String[]{"armor", "damage", "speed", "health"};
            String chosenBuff = commonBuffs[EnchanterEntity.this.f_19796_.m_188503_(commonBuffs.length)];
            if (chosenBuff.equals("armor")) {
                this.applyAttributeBuff(mob, Attributes.f_22284_, 2.0, 3);
                mob.getPersistentData().m_128379_("armor", true);
            } else if (chosenBuff.equals("damage")) {
                this.applyAttributeBuff(mob, Attributes.f_22281_, 0.5, 3);
                mob.getPersistentData().m_128379_("damage", true);
            } else if (chosenBuff.equals("speed")) {
                this.applyAttributeBuff(mob, Attributes.f_22279_, 0.15, 3);
                mob.getPersistentData().m_128379_("speed", true);
            } else if (chosenBuff.equals("health")) {
                this.applyAttributeBuff(mob, Attributes.f_22276_, 4.0, 3);
                mob.getPersistentData().m_128379_("health", true);
            }
        }

        private void applyAttributeBuff(Mob mob, Attribute attribute, double increment, int maxStacks) {
            UUID attrUUID;
            if (attribute == Attributes.f_22279_) {
                attrUUID = UUID.fromString("cf116312-b5ea-4b73-8859-e245d1404ba6");
            } else if (attribute == Attributes.f_22281_) {
                attrUUID = UUID.fromString("8ffaa385-f6bb-46e4-b517-8e264c965e50");
            } else if (attribute == Attributes.f_22284_) {
                attrUUID = UUID.fromString("5983fe1e-decf-4717-9078-339ec3ce5e36");
            } else if (attribute == Attributes.f_22276_) {
                attrUUID = UUID.fromString("f77a0b7c-3e58-4cf0-bf9c-4b312c1d6051");
            } else if (attribute == Attributes.f_22282_) {
                attrUUID = UUID.fromString("d69e78a8-f4ea-4a99-b6aa-12e4fd28db42");
            } else if (attribute == Attributes.f_22278_) {
                attrUUID = UUID.fromString("b3a2d7f8-09d1-46a5-bf2f-49a3d8f57334");
            } else {
                return;
            }
            AttributeInstance attrInstance = mob.m_21051_(attribute);
            if (attrInstance != null) {
                AttributeModifier existingModifier = attrInstance.m_22111_(attrUUID);
                if (existingModifier != null) {
                    double newValue = existingModifier.m_22218_() + increment;
                    if (newValue <= increment * (double)maxStacks) {
                        attrInstance.m_22120_(attrUUID);
                        AttributeModifier newModifier = new AttributeModifier(attrUUID, "enchanted_boost", newValue, attribute == Attributes.f_22284_ || attribute == Attributes.f_22276_ || attribute == Attributes.f_22278_ ? AttributeModifier.Operation.ADDITION : AttributeModifier.Operation.MULTIPLY_TOTAL);
                        attrInstance.m_22118_(newModifier);
                    }
                } else {
                    AttributeModifier modifier = new AttributeModifier(attrUUID, "enchanted_boost", increment, attribute == Attributes.f_22284_ || attribute == Attributes.f_22276_ || attribute == Attributes.f_22278_ ? AttributeModifier.Operation.ADDITION : AttributeModifier.Operation.MULTIPLY_TOTAL);
                    attrInstance.m_22118_(modifier);
                }
            }
        }

        private void applyUncommonBuff(Mob mob) {
            String[] uncommonTags = new String[]{"bristle", "deflect", "charge", "petrify"};
            String chosenTag = uncommonTags[EnchanterEntity.this.f_19796_.m_188503_(uncommonTags.length)];
            if (chosenTag.equals("charge")) {
                this.applyAttributeBuff(mob, Attributes.f_22282_, 0.15, 3);
                mob.getPersistentData().m_128379_("charge", true);
            } else if (chosenTag.equals("petrify")) {
                this.applyAttributeBuff(mob, Attributes.f_22278_, 1.0, 3);
                mob.getPersistentData().m_128379_("petrify", true);
            } else {
                mob.getPersistentData().m_128379_(chosenTag, true);
            }
        }

        private void applyRareBuff(Mob mob) {
            String[] rareTags = new String[]{"gravital", "fire_trail", "radiant", "flaming", "freezing"};
            String chosenTag = rareTags[EnchanterEntity.this.f_19796_.m_188503_(rareTags.length)];
            mob.getPersistentData().m_128379_(chosenTag, true);
        }
    }
}

