/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import java.util.List;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class FallingIceEntity
extends Monster {
    private LivingEntity target;
    private int trackingTicks = 0;
    private boolean hasStoppedTracking = false;

    public FallingIceEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<FallingIceEntity>)((EntityType)RedevModEntities.FALLING_ICE.get()), world);
    }

    public FallingIceEntity(EntityType<FallingIceEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 0;
        this.m_21557_(false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.target == null) {
            this.findNewTarget();
        }
        if (this.target != null && !this.hasStoppedTracking) {
            this.followTarget();
            ++this.trackingTicks;
            if (this.trackingTicks >= 60) {
                this.hasStoppedTracking = true;
                this.m_20242_(false);
            }
        }
        if (!this.m_9236_().f_46443_ && this.m_20096_()) {
            this.explodeOnImpact();
            this.m_146870_();
        }
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 3; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.m_8107_();
    }

    private void findNewTarget() {
        List entitiesBelow = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82377_(1.5, -3.0, 1.5), e -> e.m_6084_() && !(e instanceof FallingIceEntity));
        if (!entitiesBelow.isEmpty()) {
            this.target = (LivingEntity)entitiesBelow.get(0);
            this.m_20242_(true);
        }
    }

    private void followTarget() {
        if (this.target != null) {
            this.m_20242_(true);
            double targetX = this.target.m_20185_();
            double targetY = this.target.m_20186_() + 3.0;
            double targetZ = this.target.m_20189_();
            double deltaX = targetX - this.m_20185_();
            double deltaY = targetY - this.m_20186_();
            double deltaZ = targetZ - this.m_20189_();
            float glideSpeed = 0.75f;
            this.m_20334_(deltaX * (double)glideSpeed, deltaY * (double)glideSpeed, deltaZ * (double)glideSpeed);
        }
    }

    private void explodeOnImpact() {
        if (!this.m_9236_().f_46443_) {
            for (int i = 0; i < 20; ++i) {
                double xOffset = Mth.m_216263_((RandomSource)this.f_19796_, (double)-0.5, (double)0.5);
                double zOffset = Mth.m_216263_((RandomSource)this.f_19796_, (double)-0.5, (double)0.5);
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50126_.m_49966_()), this.m_20185_() + xOffset, this.m_20186_(), this.m_20189_() + zOffset, 0.0, 0.1, 0.0);
            }
            List affectedEntities = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(1.5), e -> e.m_6084_());
            for (LivingEntity entity : affectedEntities) {
                if (!entity.m_146890_()) {
                    entity.m_146917_(entity.m_146888_() + 60);
                }
                entity.m_6469_(this.m_269291_().m_269109_(), 8.0f);
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 3));
            }
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        return false;
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entityIn) {
    }

    protected void m_6138_() {
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.0);
        builder = builder.m_22268_(Attributes.f_22276_, 10.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 8.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        return builder;
    }
}

