/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import javax.annotation.Nullable;
import net.mcreator.redev.entity.PillarEntity;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class GeomancerEntity
extends SpellcasterIllager {
    private static final EntityDataAccessor<Integer> SPELL_COOLDOWN = SynchedEntityData.m_135353_(GeomancerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int CAST_DURATION = 20;

    public GeomancerEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<GeomancerEntity>)((EntityType)RedevModEntities.GEOMANCER.get()), world);
    }

    public GeomancerEntity(EntityType<GeomancerEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 8;
        this.m_21557_(false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new GeomancerSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.8, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPELL_COOLDOWN, (Object)this.getRandomCooldown());
    }

    public void m_6075_() {
        super.m_6075_();
        int cooldown = (Integer)this.f_19804_.m_135370_(SPELL_COOLDOWN);
        if (cooldown > 0) {
            this.f_19804_.m_135381_(SPELL_COOLDOWN, (Object)(cooldown - 1));
        }
    }

    public boolean isSpellReady() {
        return (Integer)this.f_19804_.m_135370_(SPELL_COOLDOWN) <= 0;
    }

    private void resetSpellCooldown() {
        this.f_19804_.m_135381_(SPELL_COOLDOWN, (Object)this.getRandomCooldown());
    }

    private int getRandomCooldown() {
        return this.f_19796_.m_188503_(21) + 80;
    }

    public MobType m_6336_() {
        return MobType.f_21643_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:geomancer.idle"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:geomancer.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:geomancer.death"));
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.evoker.celebrate"));
    }

    public SoundEvent m_7894_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.evoker.cast_spell"));
    }

    public void m_7895_(int wave, boolean p_37844_) {
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        return retval;
    }

    public static void init() {
        Raid.RaiderType.create((String)"geomancer", (EntityType)((EntityType)RedevModEntities.GEOMANCER.get()), (int[])new int[]{0, 0, 0, 0, 0, 0, 0, 0});
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.4);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22281_, 4.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    private class GeomancerSpellGoal
    extends Goal {
        private static final int TOTAL_CAST_TIME = 20;
        private static final int FIREBALL_DELAY = 6;
        private int castingTicks;
        private boolean isCasting;
        private boolean isFireballSpell;
        private int fireballCount = 0;

        private GeomancerSpellGoal() {
        }

        public boolean m_8036_() {
            return GeomancerEntity.this.isSpellReady() && GeomancerEntity.this.m_5448_() != null;
        }

        public void m_8056_() {
            this.castingTicks = 20;
            this.isCasting = true;
            this.fireballCount = 0;
            boolean bl = this.isFireballSpell = GeomancerEntity.this.m_217043_().m_188501_() < 0.3f;
            if (this.isFireballSpell) {
                GeomancerEntity.this.m_33727_(SpellcasterIllager.IllagerSpell.WOLOLO);
                GeomancerEntity.this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:geomancer.spawn_fireball")), 1.0f, 1.0f);
            } else {
                GeomancerEntity.this.m_33727_(SpellcasterIllager.IllagerSpell.SUMMON_VEX);
                GeomancerEntity.this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.evoker.prepare_attack")), 1.0f, 1.0f);
            }
        }

        public void m_8037_() {
            if (this.castingTicks > 0) {
                GeomancerEntity.this.m_21573_().m_26573_();
            }
            --this.castingTicks;
            if (this.isFireballSpell && this.castingTicks % 6 == 0 && this.fireballCount < 4) {
                this.castFireball();
                ++this.fireballCount;
            }
            if (this.castingTicks == 0) {
                if (!this.isFireballSpell) {
                    this.castPillars();
                }
                this.m_8041_();
            }
        }

        public boolean m_8045_() {
            return this.castingTicks > 0;
        }

        public void m_8041_() {
            this.isCasting = false;
            GeomancerEntity.this.m_33727_(SpellcasterIllager.IllagerSpell.NONE);
            GeomancerEntity.this.resetSpellCooldown();
            GeomancerEntity.this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.evoker.cast_spell")), 1.0f, 1.0f);
        }

        private void castFireball() {
            if (GeomancerEntity.this.m_5448_() == null) {
                return;
            }
            Level world = GeomancerEntity.this.m_9236_();
            Vec3 geomancerPos = GeomancerEntity.this.m_20182_();
            Vec3 targetPos = GeomancerEntity.this.m_5448_().m_20182_();
            double dx = targetPos.f_82479_ - geomancerPos.f_82479_;
            double dy = targetPos.f_82480_ + 1.0 - (geomancerPos.f_82480_ + 2.5);
            double dz = targetPos.f_82481_ - geomancerPos.f_82481_;
            SmallFireball fireball = new SmallFireball(world, (LivingEntity)GeomancerEntity.this, dx, dy, dz);
            fireball.m_6027_(geomancerPos.f_82479_, geomancerPos.f_82480_ + 2.5, geomancerPos.f_82481_);
            world.m_7967_((Entity)fireball);
        }

        private void castPillars() {
            if (GeomancerEntity.this.m_5448_() == null) {
                return;
            }
            Vec3 targetPos = GeomancerEntity.this.m_5448_().m_20182_();
            Level world = GeomancerEntity.this.m_9236_();
            RandomSource random = GeomancerEntity.this.m_217043_();
            int[][] offsets = new int[][]{{-1, -1}, {0, -1}, {1, -1}, {-1, 0}, {1, 0}, {-1, 1}, {0, 1}, {1, 1}};
            GeomancerEntity.this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:geomancer.spawn_wall")), 1.0f, 1.0f);
            for (int[] offset : offsets) {
                double z;
                double x;
                double y;
                if (!(random.m_188501_() < 0.7f) || (y = this.findValidGroundY(world, x = targetPos.f_82479_ + (double)offset[0], targetPos.f_82480_, z = targetPos.f_82481_ + (double)offset[1])) == -1.0) continue;
                PillarEntity pillar = new PillarEntity((EntityType<PillarEntity>)((EntityType)RedevModEntities.PILLAR.get()), world);
                if (random.m_188501_() < 0.3f) {
                    pillar.m_20088_().m_135381_(PillarEntity.IS_EXPLOSIVE, (Object)true);
                    pillar.m_20088_().m_135381_(PillarEntity.EXPLOSIVE_TIMER, (Object)60);
                }
                pillar.m_6027_(x, y, z);
                world.m_7967_((Entity)pillar);
            }
        }

        private double findValidGroundY(Level world, double x, double startY, double z) {
            BlockState state;
            int i;
            int maxDistance = 8;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (i = 0; i < maxDistance; ++i) {
                pos.m_122169_(x, startY - (double)i, z);
                state = world.m_8055_((BlockPos)pos);
                if (state.m_60795_() || state.m_247087_()) continue;
                return startY - (double)i + 1.0;
            }
            for (i = 0; i < maxDistance; ++i) {
                pos.m_122169_(x, startY + (double)i, z);
                state = world.m_8055_((BlockPos)pos);
                if (!state.m_60795_() && !state.m_247087_()) continue;
                return startY + (double)i;
            }
            return -1.0;
        }
    }
}

