/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mcreator.redev.init.RedevModEntities;
import net.mcreator.redev.init.RedevModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class MunchkinEntity
extends Monster {
    private static final UUID FEEDING_HEALTH_MODIFIER_UUID = UUID.fromString("24728e63-f7bb-4ff0-abf4-cd5955ca5121");
    private static final UUID FEEDING_DAMAGE_MODIFIER_UUID = UUID.fromString("68f9fec7-8e26-4366-a10e-bc0e4949a955");
    public static final EntityDataAccessor<Integer> DATA_MUNCHKIN_VARIANT = SynchedEntityData.m_135353_(MunchkinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_FEEDING_VALUE = SynchedEntityData.m_135353_(MunchkinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int MAX_FEEDING_VALUE = 30;

    public MunchkinEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<MunchkinEntity>)((EntityType)RedevModEntities.MUNCHKIN.get()), world);
    }

    public MunchkinEntity(EntityType<MunchkinEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 5;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_MUNCHKIN_VARIANT, (Object)0);
        this.f_19804_.m_135372_(DATA_FEEDING_VALUE, (Object)0);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity target) {
                double reach = MunchkinEntity.this.m_20205_() * 2.0f + target.m_20205_();
                return reach * reach;
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(11, (Goal)new FollowMobGoal((Mob)this, 1.0, 10.0f, 5.0f));
        this.f_21346_.m_25352_(12, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21346_.m_25352_(13, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, false, false));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public double m_6048_() {
        return super.m_6048_() - 0.5;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.shulker.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.shulker.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.shulker.death"));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        FoodProperties foodProperties;
        ItemStack stack = player.m_21120_(hand);
        ItemStack mainHandItem = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHandItem = player.m_21120_(InteractionHand.OFF_HAND);
        if (stack.m_41614_() && (foodProperties = stack.m_41720_().m_41473_()) != null) {
            foodProperties.m_38749_().forEach(pair -> {
                MobEffectInstance effectInstance = (MobEffectInstance)pair.getFirst();
                if (effectInstance != null) {
                    this.m_7292_(new MobEffectInstance(effectInstance));
                }
            });
            int nutritionalValue = foodProperties.m_38744_();
            this.m_5634_(nutritionalValue);
            int currentFeedingValue = (Integer)this.f_19804_.m_135370_(DATA_FEEDING_VALUE);
            int newFeedingValue = Math.min(currentFeedingValue + nutritionalValue, 30);
            this.f_19804_.m_135381_(DATA_FEEDING_VALUE, (Object)newFeedingValue);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_() instanceof PotionItem) {
            List potionEffects = PotionUtils.m_43547_((ItemStack)stack);
            for (MobEffectInstance effect : potionEffects) {
                this.m_7292_(new MobEffectInstance(effect));
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.m_5496_(SoundEvents.f_11911_, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_() == Items.f_42590_) {
            int currentFeedingValue = this.getFeedingValue();
            if (currentFeedingValue >= 3) {
                ItemStack xpBottle;
                int feedingDecrease = 3 + this.m_9236_().f_46441_.m_188503_(3);
                int newFeedingValue = Math.max(0, currentFeedingValue - feedingDecrease);
                this.setFeedingValue(newFeedingValue);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                if (!player.m_36356_(xpBottle = new ItemStack((ItemLike)Items.f_42612_))) {
                    this.m_19983_(xpBottle);
                }
                this.m_5496_(SoundEvents.f_11772_, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)Component.m_237113_((String)"The Munchkin doesn't have enough energy!"), true);
            return InteractionResult.FAIL;
        }
        if (mainHandItem.m_41720_() == Items.f_42612_ && offHandItem.m_41720_() == Items.f_42591_ || mainHandItem.m_41720_() == Items.f_42591_ && offHandItem.m_41720_() == Items.f_42612_) {
            int currentFeedingValue = this.getFeedingValue();
            if (currentFeedingValue >= 6) {
                ItemStack enchantedSpit;
                int feedingDecrease = 6 + this.m_9236_().f_46441_.m_188503_(4);
                this.setFeedingValue(currentFeedingValue - feedingDecrease);
                if (!player.m_150110_().f_35937_) {
                    if (mainHandItem.m_41720_() == Items.f_42612_) {
                        mainHandItem.m_41774_(1);
                    } else {
                        offHandItem.m_41774_(1);
                    }
                    if (mainHandItem.m_41720_() == Items.f_42591_) {
                        mainHandItem.m_41774_(1);
                    } else {
                        offHandItem.m_41774_(1);
                    }
                }
                if (!player.m_36356_(enchantedSpit = new ItemStack((ItemLike)RedevModItems.BOTTLE_OF_ENCHANTED_SPIT.get()))) {
                    this.m_19983_(enchantedSpit);
                }
                this.m_5496_(SoundEvents.f_12098_, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)Component.m_237113_((String)"The Munchkin is too weak to create enchanted spit!"), true);
            return InteractionResult.FAIL;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            int currentFeedingValue = (Integer)this.f_19804_.m_135370_(DATA_FEEDING_VALUE);
            int removedFeedingValue = Math.min(currentFeedingValue, (int)amount);
            int newFeedingValue = currentFeedingValue - removedFeedingValue;
            this.setFeedingValue(newFeedingValue);
            if (!this.m_9236_().f_46443_ && removedFeedingValue > 0) {
                int xpOrbValue;
                for (int xpToDrop = removedFeedingValue * 3; xpToDrop > 0; xpToDrop -= xpOrbValue) {
                    xpOrbValue = ExperienceOrb.m_20782_((int)xpToDrop);
                    this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), xpOrbValue));
                }
            }
            return true;
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        this.updateAttributes();
        this.m_6210_();
    }

    public void m_6210_() {
        float scale = 1.0f + (float)this.getFeedingValue() * 0.1f;
        scale = Math.min(scale, 4.0f);
        this.m_20011_(this.m_6095_().m_20680_().m_20388_(scale).m_20393_(this.m_20182_()));
    }

    public int getMunchkinVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_MUNCHKIN_VARIANT);
    }

    public void setMunchkinVariant(int variant) {
        this.f_19804_.m_135381_(DATA_MUNCHKIN_VARIANT, (Object)variant);
    }

    public int getFeedingValue() {
        return (Integer)this.f_19804_.m_135370_(DATA_FEEDING_VALUE);
    }

    public void setFeedingValue(int value) {
        value = Math.min(value, 30);
        this.f_19804_.m_135381_(DATA_FEEDING_VALUE, (Object)value);
        this.updateAttributes();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("munchkinVariant", ((Integer)this.f_19804_.m_135370_(DATA_MUNCHKIN_VARIANT)).intValue());
        compound.m_128405_("munchkinFeedingValue", ((Integer)this.f_19804_.m_135370_(DATA_FEEDING_VALUE)).intValue());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("munchkinVariant")) {
            this.f_19804_.m_135381_(DATA_MUNCHKIN_VARIANT, (Object)compound.m_128451_("munchkinVariant"));
        }
        if (compound.m_128441_("munchkinFeedingValue")) {
            this.f_19804_.m_135381_(DATA_FEEDING_VALUE, (Object)compound.m_128451_("munchkinFeedingValue"));
            this.updateAttributes();
        }
    }

    private void applyModifier(Attribute attribute, UUID uuid, double value, AttributeModifier.Operation operation) {
        AttributeInstance attributeInstance = this.m_21051_(attribute);
        if (attributeInstance == null) {
            return;
        }
        attributeInstance.m_22120_(uuid);
        AttributeModifier modifier = new AttributeModifier(uuid, "Feeding bonus", value, operation);
        attributeInstance.m_22125_(modifier);
    }

    private void updateAttributes() {
        int feedingValue = this.getFeedingValue();
        double healthBonus = feedingValue;
        this.applyModifier(Attributes.f_22276_, FEEDING_HEALTH_MODIFIER_UUID, healthBonus, AttributeModifier.Operation.ADDITION);
        double damageBonus = (double)feedingValue / 3.0;
        this.applyModifier(Attributes.f_22281_, FEEDING_DAMAGE_MODIFIER_UUID, damageBonus, AttributeModifier.Operation.ADDITION);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        super.m_6518_(level, difficulty, reason, spawnData, tag);
        BlockPos spawnPos = this.m_20183_();
        ResourceLocation biomeName = ((ResourceKey)level.m_204166_(spawnPos).m_203543_().orElseThrow()).m_135782_();
        if (biomeName.equals((Object)new ResourceLocation("minecraft:dark_forest"))) {
            this.setMunchkinVariant(1);
        } else if (biomeName.equals((Object)new ResourceLocation("minecraft:badlands")) || biomeName.equals((Object)new ResourceLocation("minecraft:wooded_badlands")) || biomeName.equals((Object)new ResourceLocation("minecraft:eroded_badlands")) || biomeName.equals((Object)new ResourceLocation("minecraft:savanna")) || biomeName.equals((Object)new ResourceLocation("minecraft:windswept_savanna")) || biomeName.equals((Object)new ResourceLocation("minecraft:savanna_plateau")) || biomeName.equals((Object)new ResourceLocation("minecraft:desert"))) {
            this.setMunchkinVariant(2);
        } else {
            this.setMunchkinVariant(0);
        }
        this.updateAttributes();
        return spawnData;
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)RedevModEntities.MUNCHKIN.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.m_217057_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 1.0);
        builder = builder.m_22268_(Attributes.f_22281_, 5.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.2);
        return builder;
    }
}

