/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.mcreator.redev.init.RedevModBlocks;
import net.mcreator.redev.init.RedevModEntities;
import net.mcreator.redev.init.RedevModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class OracleEntity
extends AbstractVillager {
    private BlockPos wanderTarget;
    private int glowTick;
    private int despawnDelay = 48000;

    public OracleEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<OracleEntity>)((EntityType)RedevModEntities.ORACLE.get()), world);
    }

    public OracleEntity(EntityType<OracleEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 1;
        this.m_21557_(false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new WanderToPositionGoal(this, 2.0, 0.35));
        this.f_21345_.m_25352_(2, (Goal)new AvoidLightGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Monster.class, 6.0f, 1.0, 1.2));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new FollowPlayerGoal((PathfinderMob)this, 1.0, 3.0f, 16.0f));
    }

    public void setWanderTarget(@Nullable BlockPos pos) {
        this.wanderTarget = pos;
    }

    public BlockPos getWanderTarget() {
        return this.wanderTarget;
    }

    public void setDespawnDelay(int ticks) {
        this.despawnDelay = ticks;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("OracleDespawnDelay", this.despawnDelay);
        if (this.wanderTarget != null) {
            tag.m_128365_("WanderTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.wanderTarget));
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("OracleDespawnDelay")) {
            this.despawnDelay = tag.m_128451_("OracleDespawnDelay");
            if (tag.m_128441_("WanderTarget")) {
                this.wanderTarget = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("WanderTarget"));
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (!this.m_35306_() && --this.despawnDelay <= 0) {
                this.m_146870_();
                return;
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
                double y = this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_();
                double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.01, 0.0);
            }
        }
        ++this.glowTick;
    }

    public int getGlowTick() {
        return this.glowTick;
    }

    public void m_8032_() {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.warden.ambient")), this.m_6121_(), 1.7f);
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.warden.step")), 0.15f, 1.4f);
    }

    protected void m_6677_(DamageSource source) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.warden.hurt")), this.m_6121_(), 1.7f);
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.warden.death")), this.m_6121_(), 1.7f);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268671_) || source.m_276093_(DamageTypes.f_268722_) || source.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        if (!this.m_9236_().f_46443_) {
            this.randomTeleport();
        }
        this.spawnHurtParticles();
        return super.m_6469_(source, amount);
    }

    private void randomTeleport() {
        for (int i = 0; i < 16; ++i) {
            double dx = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 16.0;
            double dy = this.m_20186_() + (double)this.f_19796_.m_188503_(8) - 4.0;
            double dz = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 16.0;
            BlockPos targetPos = new BlockPos((int)dx, (int)dy, (int)dz);
            BlockState state = this.m_9236_().m_8055_(targetPos);
            BlockState below = this.m_9236_().m_8055_(targetPos.m_7495_());
            if (!state.m_60795_() || !below.m_60783_((BlockGetter)this.m_9236_(), targetPos.m_7495_(), Direction.UP)) continue;
            this.m_6021_(dx, dy, dz);
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.enderman.teleport")), this.m_5720_(), 1.0f, 1.0f);
            return;
        }
    }

    private void spawnHurtParticles() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        for (int i = 0; i < 40; ++i) {
            double px = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
            double py = this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_();
            double pz = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, px, py, pz, 1, 0.0, 0.01, 0.0, 0.01);
        }
    }

    public boolean m_5825_() {
        return true;
    }

    protected void m_8058_(MerchantOffer offer) {
    }

    public SoundEvent m_7596_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.amethyst_block.resonate"));
    }

    protected void m_7604_() {
        this.m_6616_().clear();
        RandomSource random = this.m_9236_().f_46441_;
        this.addRandomTradesFromList(this.m_6616_(), SellingTrades.ALL, 2, random);
        this.addRandomTradesFromList(this.m_6616_(), SpecialBuyTrades.ALL, 2, random);
        this.addRandomTradesFromList(this.m_6616_(), RegularBuyTrades.ALL, 5, random);
    }

    private void addRandomTradesFromList(MerchantOffers offers, List<VillagerTrades.ItemListing> tradeList, int count, RandomSource random) {
        ArrayList<VillagerTrades.ItemListing> copy = new ArrayList<VillagerTrades.ItemListing>(tradeList);
        Collections.shuffle(copy, new Random(random.m_188505_()));
        for (int i = 0; i < count && i < copy.size(); ++i) {
            MerchantOffer offer = ((VillagerTrades.ItemListing)copy.get(i)).m_213663_((Entity)this, random);
            if (offer == null) continue;
            offers.add((Object)offer);
        }
    }

    public static VillagerTrades.ItemListing trade(ItemStack input, ItemStack output) {
        return (entity, random) -> new MerchantOffer(input, output, 1, 15, 0.05f);
    }

    public static VillagerTrades.ItemListing customTrade(Function<RandomSource, MerchantOffer> generator) {
        return (entity, random) -> (MerchantOffer)generator.apply(random);
    }

    public boolean m_7826_() {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob partner) {
        return null;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_150930_((Item)RedevModItems.ORACLE_SPAWN_EGG.get()) || this.m_35306_() || this.m_6162_()) {
            return super.m_6071_(player, hand);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_7189_(player);
            this.m_45301_(player, this.m_5446_(), 1);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)RedevModEntities.ORACLE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL && pos.m_123342_() < 0 && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.m_217057_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.175).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22278_, 0.2).m_22268_(Attributes.f_22282_, 0.15);
    }

    class WanderToPositionGoal
    extends Goal {
        final OracleEntity mob;
        final double stopDistance;
        final double speedModifier;

        WanderToPositionGoal(OracleEntity mob, double stopDistance, double speedModifier) {
            this.mob = mob;
            this.stopDistance = stopDistance;
            this.speedModifier = speedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public void m_8041_() {
            this.mob.setWanderTarget(null);
            this.mob.m_21573_().m_26573_();
        }

        public boolean m_8036_() {
            BlockPos target = this.mob.getWanderTarget();
            return target != null && !target.m_203195_((Position)this.mob.m_20182_(), this.stopDistance);
        }

        public void m_8037_() {
            BlockPos target = this.mob.getWanderTarget();
            if (target != null && this.mob.m_21573_().m_26571_()) {
                if (!target.m_203195_((Position)this.mob.m_20182_(), 10.0)) {
                    Vec3 direction = target.m_252807_().m_82546_(this.mob.m_20182_()).m_82541_().m_82490_(10.0);
                    Vec3 targetPos = this.mob.m_20182_().m_82549_(direction);
                    this.mob.m_21573_().m_26519_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, this.speedModifier);
                } else {
                    this.mob.m_21573_().m_26519_((double)target.m_123341_(), (double)target.m_123342_(), (double)target.m_123343_(), this.speedModifier);
                }
            }
        }
    }

    public static class AvoidLightGoal
    extends Goal {
        private final PathfinderMob mob;
        private final double speed;

        public AvoidLightGoal(PathfinderMob mob, double speed) {
            this.mob = mob;
            this.speed = speed;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            BlockPos pos = this.mob.m_20183_();
            return this.mob.m_9236_().m_45517_(LightLayer.BLOCK, pos) > 7;
        }

        public void m_8056_() {
            BlockPos pos = this.findDarkerPos();
            if (pos != null) {
                this.mob.m_21573_().m_26519_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), this.speed);
            }
        }

        private BlockPos findDarkerPos() {
            BlockPos best = null;
            int bestLight = Integer.MAX_VALUE;
            for (int dx = -6; dx <= 6; ++dx) {
                for (int dz = -6; dz <= 6; ++dz) {
                    BlockPos check = this.mob.m_20183_().m_7918_(dx, 0, dz);
                    int light = this.mob.m_9236_().m_45517_(LightLayer.BLOCK, check);
                    if (light >= bestLight) continue;
                    bestLight = light;
                    best = check;
                }
            }
            return best;
        }
    }

    public class FollowPlayerGoal
    extends Goal {
        private final PathfinderMob mob;
        private Player targetPlayer;
        private final double speed;
        private final float stopDistance;
        private final float maxDistance;
        private final Level level;

        public FollowPlayerGoal(PathfinderMob mob, double speed, float stopDistance, float maxDistance) {
            this.mob = mob;
            this.speed = speed;
            this.stopDistance = stopDistance;
            this.maxDistance = maxDistance;
            this.level = mob.m_9236_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            List players = this.level.m_45976_(Player.class, this.mob.m_20191_().m_82400_((double)this.maxDistance));
            for (Player player : players) {
                if (player.m_5833_() || player.m_7500_()) continue;
                this.targetPlayer = player;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.targetPlayer != null && this.targetPlayer.m_6084_() && this.mob.m_20280_((Entity)this.targetPlayer) > (double)(this.stopDistance * this.stopDistance) && this.mob.m_20280_((Entity)this.targetPlayer) < (double)(this.maxDistance * this.maxDistance);
        }

        public void m_8041_() {
            this.targetPlayer = null;
            this.mob.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (this.targetPlayer != null) {
                this.mob.m_21573_().m_5624_((Entity)this.targetPlayer, this.speed);
            }
        }
    }

    public static class SellingTrades {
        public static final List<VillagerTrades.ItemListing> ALL = List.of(OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_41854_), new ItemStack((ItemLike)Items.f_42616_), 2, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_151079_, 4), new ItemStack((ItemLike)Items.f_42616_), 2, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42546_), new ItemStack((ItemLike)Items.f_42616_), 2, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42448_), new ItemStack((ItemLike)Items.f_42616_, 2), 2, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42522_), new ItemStack((ItemLike)Items.f_42616_, 2), 2, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42584_), new ItemStack((ItemLike)Items.f_42616_, 3), 2, 15, 0.05f)));
    }

    public static class SpecialBuyTrades {
        public static final List<VillagerTrades.ItemListing> ALL = List.of(OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)RedevModBlocks.DEATHCAP_MUSHROOM.get()), 2, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)Items.f_42542_, 3), 4, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)Items.f_42588_, 2), 4, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 3), Raid.m_37779_(), 1, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)Items.f_220194_), 2, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 6), new ItemStack((ItemLike)RedevModItems.BINDING_CHAINS.get()), 1, 15, 0.05f)), OracleEntity.customTrade(random -> {
            int xpLevel = Mth.m_216271_((RandomSource)random, (int)12, (int)24);
            ItemStack pick = new ItemStack((ItemLike)Items.f_42390_);
            EnchantmentHelper.m_220292_((RandomSource)random, (ItemStack)pick, (int)xpLevel, (boolean)false);
            int cost = xpLevel;
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, cost), pick, 1, 15, 0.05f);
        }));
    }

    public static class RegularBuyTrades {
        public static final List<VillagerTrades.ItemListing> ALL = List.of(OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)Items.f_151051_, 4), 4, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)Items.f_151050_), 4, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)(random.m_188499_() ? Items.f_41953_ : Items.f_41952_), 3), 4, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)Items.f_151025_, 4), 5, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)Items.f_151016_, 4), 6, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)Items.f_41958_, 4), 6, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)Items.f_42170_, 4), 6, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 2), new ItemStack((ItemLike)Items.f_42778_), 4, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 2), new ItemStack((ItemLike)Items.f_42446_), 2, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 3), new ItemStack((ItemLike)Items.f_151053_), 6, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 3), new ItemStack((ItemLike)Items.f_151049_), 4, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 3), new ItemStack((ItemLike)Items.f_151056_, 4), 6, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 3), new ItemStack((ItemLike)Items.f_42656_), 2, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 3), new ItemStack((ItemLike)RedevModItems.DEPTH_METER.get()), 2, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)RedevModItems.FLASK.get()), 2, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)RedevModItems.ARCHER_HELMET.get()), 1, 15, 0.05f)), OracleEntity.customTrade(random -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)Items.f_220224_), 4, 15, 0.05f)));
    }
}

