/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import javax.annotation.Nullable;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class PillarEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> IS_EXPLOSIVE = SynchedEntityData.m_135353_(PillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> EXPLOSIVE_TIMER = SynchedEntityData.m_135353_(PillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public PillarEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<PillarEntity>)((EntityType)RedevModEntities.PILLAR.get()), world);
    }

    public PillarEntity(EntityType<PillarEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.0f);
        this.f_21364_ = 0;
        this.m_21557_(true);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_EXPLOSIVE, (Object)false);
        this.f_19804_.m_135372_(EXPLOSIVE_TIMER, (Object)60);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(IS_EXPLOSIVE, (Object)tag.m_128471_("isExplosive"));
        this.f_19804_.m_135381_(EXPLOSIVE_TIMER, (Object)tag.m_128451_("explosiveTimer"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("isExplosive", ((Boolean)this.f_19804_.m_135370_(IS_EXPLOSIVE)).booleanValue());
        tag.m_128405_("explosiveTimer", ((Integer)this.f_19804_.m_135370_(EXPLOSIVE_TIMER)).intValue());
    }

    public boolean isExplosive() {
        return (Boolean)this.f_19804_.m_135370_(IS_EXPLOSIVE);
    }

    public int getExplosiveTimer() {
        return (Integer)this.f_19804_.m_135370_(EXPLOSIVE_TIMER);
    }

    public void m_6075_() {
        super.m_6075_();
        int timer = (Integer)this.f_19804_.m_135370_(EXPLOSIVE_TIMER);
        if (((Boolean)this.f_19804_.m_135370_(IS_EXPLOSIVE)).booleanValue()) {
            if (timer > 0) {
                this.f_19804_.m_135381_(EXPLOSIVE_TIMER, (Object)(timer - 1));
            } else {
                this.explode();
            }
        } else if (timer > 0) {
            this.f_19804_.m_135381_(EXPLOSIVE_TIMER, (Object)(timer - 1));
        } else {
            this.m_146870_();
        }
    }

    private void explode() {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_254849_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f, Level.ExplosionInteraction.NONE);
            this.m_146870_();
        }
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.dripstone_block.step"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.dripstone_block.hit"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.dripstone_block.break"));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (damagesource.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.m_7640_() instanceof ThrownPotion || damagesource.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268565_) || damagesource.m_276093_(DamageTypes.f_268448_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268714_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268493_) || damagesource.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_7337_(Entity entity) {
        return true;
    }

    public boolean m_5829_() {
        return true;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(world, difficulty, reason, livingdata, tag);
        if (this.f_19796_.m_188501_() < 0.3f) {
            this.f_19804_.m_135381_(IS_EXPLOSIVE, (Object)true);
            this.f_19804_.m_135381_(EXPLOSIVE_TIMER, (Object)60);
        }
        return data;
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.0);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        return builder;
    }
}

