/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class PortalGuardEntity
extends Monster {
    private int tntAttackCooldown = 0;
    private int tntAttackTick = -1;
    private PrimedTnt tntPassenger;
    private int attackAnimationTick;
    private int throwAnimationTimer;
    private int throwAnimationSpeed;

    public PortalGuardEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<PortalGuardEntity>)((EntityType)RedevModEntities.PORTAL_GUARD.get()), world);
    }

    public PortalGuardEntity(EntityType<PortalGuardEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 40;
        this.m_21557_(false);
        this.m_6210_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public double m_6048_() {
        return super.m_6048_() + 1.2;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new ThrowTntGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal((Mob)this));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.throwAnimationTimer > 0) {
            --this.throwAnimationTimer;
        }
        if (this.tntAttackCooldown > 0) {
            --this.tntAttackCooldown;
        }
        if (this.tntAttackTick > 0) {
            --this.tntAttackTick;
        } else if (this.tntAttackTick == 0 && this.tntPassenger != null && this.m_5448_() != null) {
            LivingEntity target = this.m_5448_();
            Vec3 direction = new Vec3(target.m_20185_() - this.m_20185_(), target.m_20227_(0.5) - this.m_20227_(0.5), target.m_20189_() - this.m_20189_());
            Vec3 normalized = direction.m_82541_();
            Vec3 inaccuracy = new Vec3((this.f_19796_.m_188500_() - 0.5) * 0.2, (this.f_19796_.m_188500_() - 0.5) * 0.2, (this.f_19796_.m_188500_() - 0.5) * 0.2);
            Vec3 velocity = normalized.m_82549_(inaccuracy).m_82520_(0.0, 0.3, 0.0).m_82490_(0.6);
            this.tntPassenger.m_8127_();
            this.tntPassenger.m_20256_(velocity);
            this.setThrowAnimationTimer(10);
            this.tntAttackTick = -1;
            this.tntPassenger = null;
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public int getThrowAnimationTimer() {
        return this.throwAnimationTimer;
    }

    public void setThrowAnimationTimer(int ticks) {
        this.throwAnimationTimer = ticks;
        this.m_9236_().m_7605_((Entity)this, (byte)5);
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.attackAnimationTick = 10;
        } else if (id == 5) {
            this.throwAnimationTimer = 10;
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_7327_(Entity target) {
        this.attackAnimationTick = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        float attackDamage = (float)this.m_21133_(Attributes.f_22281_);
        boolean flag = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), attackDamage);
        if (flag) {
            Player player;
            this.redirectPiglinsToTarget(target);
            this.m_19970_((LivingEntity)this, target);
            double knockbackStrength = this.m_21133_(Attributes.f_22282_);
            if (knockbackStrength > 0.0) {
                double dx = target.m_20185_() - this.m_20185_();
                double dz = target.m_20189_() - this.m_20189_();
                double distance = Math.max(Math.sqrt(dx * dx + dz * dz), 0.01);
                double knockbackX = dx / distance * knockbackStrength * 1.25;
                double knockbackZ = dz / distance * knockbackStrength * 1.25;
                double knockbackY = 0.3 * knockbackStrength;
                target.m_20256_(target.m_20184_().m_82520_(knockbackX, knockbackY, knockbackZ));
            }
            if (target instanceof Player && (player = (Player)target).m_6117_()) {
                player.m_36335_().m_41524_(player.m_21211_().m_41720_(), 200);
                player.m_5810_();
            }
        }
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.anvil.land")), 1.0f, 1.0f);
        return flag;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean result = super.m_6469_(source, amount);
        if (!this.m_9236_().f_46443_ && result && source.m_7639_() != null) {
            this.redirectPiglinsToTarget(source.m_7639_());
        }
        return result;
    }

    private void redirectPiglinsToTarget(Entity target) {
        this.m_9236_().m_6443_(Mob.class, this.m_20191_().m_82400_(20.0), mob -> mob.m_6095_().toString().contains("piglin")).forEach(mob -> {
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                mob.m_6710_(livingTarget);
            }
        });
    }

    public void startTntAttack(LivingEntity target) {
        if (this.tntPassenger != null || target == null) {
            return;
        }
        PrimedTnt tnt = (PrimedTnt)EntityType.f_20515_.m_20615_(this.m_9236_());
        if (tnt != null) {
            tnt.m_32085_(60);
            tnt.m_7678_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 0.0f, 0.0f);
            this.m_9236_().m_7967_((Entity)tnt);
            tnt.m_7998_((Entity)this, true);
            this.tntPassenger = tnt;
            this.tntAttackTick = 30;
            this.tntAttackCooldown = 320;
            this.m_21573_().m_26573_();
        }
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.piglin_brute.ambient"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.piglin_brute.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.piglin_brute.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.piglin_brute.death"));
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(1.2f);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)RedevModEntities.PORTAL_GUARD.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.m_217057_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 40.0);
        builder = builder.m_22268_(Attributes.f_22284_, 5.0);
        builder = builder.m_22268_(Attributes.f_22281_, 9.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.8);
        builder = builder.m_22268_(Attributes.f_22282_, 1.5);
        return builder;
    }

    public class ThrowTntGoal
    extends Goal {
        private final PortalGuardEntity mob;
        private int freezeTicks = 0;

        public ThrowTntGoal(PortalGuardEntity mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.tntAttackCooldown <= 0 && this.mob.tntPassenger == null;
        }

        public void m_8056_() {
            this.mob.startTntAttack(this.mob.m_5448_());
            this.mob.m_21573_().m_26573_();
            this.freezeTicks = 80;
        }

        public void m_8037_() {
            if (this.freezeTicks > 0) {
                --this.freezeTicks;
                this.mob.m_21573_().m_26573_();
            }
        }

        public boolean m_8045_() {
            return this.freezeTicks > 0 || this.mob.tntAttackTick > 0 || this.mob.tntPassenger != null;
        }
    }
}

