/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class RascalEntity
extends Monster {
    private static final EntityDataAccessor<Integer> HIDE_SEEK_TIMES = SynchedEntityData.m_135353_(RascalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public RascalEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<RascalEntity>)((EntityType)RedevModEntities.RASCAL.get()), world);
    }

    public RascalEntity(EntityType<RascalEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 0;
        this.m_21557_(false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(6, (Goal)new AvoidEntityGoal((PathfinderMob)this, Monster.class, 6.0f, 1.0, 1.2));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HIDE_SEEK_TIMES, (Object)0);
    }

    public int getHideSeekTimes() {
        return (Integer)this.f_19804_.m_135370_(HIDE_SEEK_TIMES);
    }

    public void incrementHideSeekTimes() {
        this.f_19804_.m_135381_(HIDE_SEEK_TIMES, (Object)(this.getHideSeekTimes() + 1));
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.m_19983_(new ItemStack((ItemLike)Items.f_151058_));
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.death"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("HideSeekTimes", this.getHideSeekTimes());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("HideSeekTimes")) {
            this.f_19804_.m_135381_(HIDE_SEEK_TIMES, (Object)tag.m_128451_("HideSeekTimes"));
        }
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (!this.m_9236_().f_46443_) {
            this.handleHideAndSeek();
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        if (!this.m_9236_().f_46443_) {
            this.handleHideAndSeek();
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    private void handleHideAndSeek() {
        this.incrementHideSeekTimes();
        if (this.getHideSeekTimes() >= 3) {
            this.dropRewardAndDespawn();
        } else {
            this.performEscape();
        }
    }

    private void dropRewardAndDespawn() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ResourceLocation lootTable = new ResourceLocation("redev", "gameplay/rascal_loot");
            LootParams.Builder lootParams = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81457_, (Object)serverLevel.m_269111_().m_269264_());
            LootTable table = serverLevel.m_7654_().m_278653_().m_278676_(lootTable);
            ObjectArrayList loot = table.m_287195_(lootParams.m_287235_(LootContextParamSets.f_81415_));
            for (ItemStack stack : loot) {
                this.m_19983_(stack);
            }
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 30, 0.5, 0.5, 0.5, 0.1);
            this.m_146870_();
        }
    }

    private void performEscape() {
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 30, 0.5, 0.5, 0.5, 0.1);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 300, 0, false, false));
        for (int i = 0; i < 10; ++i) {
            int newX = (int)(this.m_20185_() + (this.f_19796_.m_188500_() * 30.0 - 15.0));
            int newY = (int)(this.m_20186_() + (double)(this.f_19796_.m_188503_(6) - 3));
            int newZ = (int)(this.m_20189_() + (this.f_19796_.m_188500_() * 30.0 - 15.0));
            BlockPos newPos = new BlockPos(newX, newY, newZ);
            if (!this.m_9236_().m_8055_(newPos.m_7495_()).m_280296_() || !this.m_9236_().m_46859_(newPos)) continue;
            this.m_6021_(newX, newY, newZ);
            break;
        }
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)RedevModEntities.RASCAL.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> pos.m_123342_() <= 50 && !world.m_45527_(pos));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 15.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }
}

