/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import javax.annotation.Nullable;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class RedstoneMineEntity
extends Monster {
    private boolean snappedToGrid = false;
    private static final EntityDataAccessor<Boolean> IS_REAL = SynchedEntityData.m_135353_(RedstoneMineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> LIFE_TICKS = SynchedEntityData.m_135353_(RedstoneMineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public RedstoneMineEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<RedstoneMineEntity>)((EntityType)RedevModEntities.REDSTONE_MINE.get()), world);
    }

    public RedstoneMineEntity(EntityType<RedstoneMineEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.0f);
        this.f_21364_ = 0;
        this.m_21557_(true);
        this.m_6034_(Math.floor(this.m_20185_()) + 0.5, Math.floor(this.m_20186_()), Math.floor(this.m_20189_()) + 0.5);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_REAL, (Object)true);
        this.f_19804_.m_135372_(LIFE_TICKS, (Object)20);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("IsReal", this.isReal());
        tag.m_128405_("LifeTicks", this.getLifeTicks());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setIsReal(tag.m_128471_("IsReal"));
        this.setLifeTicks(tag.m_128451_("LifeTicks"));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.snappedToGrid && !this.m_9236_().f_46443_) {
            double snappedX = Math.floor(this.m_20185_()) + 0.5;
            double snappedY = Math.floor(this.m_20186_());
            double snappedZ = Math.floor(this.m_20189_()) + 0.5;
            this.m_6034_(snappedX, snappedY, snappedZ);
            this.snappedToGrid = true;
        }
        if (!this.m_9236_().f_46443_) {
            for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_())) {
                if (!player.m_6084_()) continue;
                if (this.isReal()) {
                    this.m_9236_().m_254849_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, Level.ExplosionInteraction.NONE);
                } else {
                    AABB box = this.m_20191_();
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 12, (box.f_82291_ - box.f_82288_) / 2.0, (box.f_82292_ - box.f_82289_) / 2.0, (box.f_82293_ - box.f_82290_) / 2.0, 0.01);
                }
                this.m_146870_();
                break;
            }
        }
        if (this.getLifeTicks() <= 0) {
            if (!this.m_9236_().f_46443_ && !this.isReal()) {
                AABB box = this.m_20191_();
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 12, (box.f_82291_ - box.f_82288_) / 2.0, (box.f_82292_ - box.f_82289_) / 2.0, (box.f_82293_ - box.f_82290_) / 2.0, 0.01);
            }
            this.m_146870_();
            return;
        }
        this.setLifeTicks(this.getLifeTicks() - 1);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData group, @Nullable CompoundTag tag) {
        SpawnGroupData result = super.m_6518_(level, difficulty, spawnType, group, tag);
        if (!this.m_9236_().f_46443_) {
            this.setIsReal(this.f_19796_.m_188501_() < 0.8f);
            this.setLifeTicks(10 + this.f_19796_.m_188503_(31));
        }
        return result;
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.0);
        builder = builder.m_22268_(Attributes.f_22276_, 10.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 0.0);
        return builder;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    public void m_7334_(Entity entity) {
    }

    public void m_20334_(double x, double y, double z) {
        super.m_20334_(0.0, 0.0, 0.0);
    }

    public boolean isReal() {
        return (Boolean)this.f_19804_.m_135370_(IS_REAL);
    }

    public void setIsReal(boolean value) {
        this.f_19804_.m_135381_(IS_REAL, (Object)value);
    }

    public int getLifeTicks() {
        return (Integer)this.f_19804_.m_135370_(LIFE_TICKS);
    }

    public void setLifeTicks(int ticks) {
        this.f_19804_.m_135381_(LIFE_TICKS, (Object)ticks);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }
}

