/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class VultureEntity
extends TamableAnimal
implements FlyingAnimal {
    private static final EntityDataAccessor<Boolean> HAS_BUNDLE = SynchedEntityData.m_135353_(VultureEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);

    public VultureEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<VultureEntity>)((EntityType)RedevModEntities.VULTURE.get()), world);
    }

    public VultureEntity(EntityType<VultureEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 3;
        this.m_21557_(false);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected PathNavigation m_6037_(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new Goal(){
            {
                this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean m_8036_() {
                return VultureEntity.this.m_5448_() != null && !VultureEntity.this.m_21566_().m_24995_();
            }

            public boolean m_8045_() {
                return VultureEntity.this.m_21566_().m_24995_() && VultureEntity.this.m_5448_() != null && VultureEntity.this.m_5448_().m_6084_();
            }

            public void m_8056_() {
                LivingEntity livingentity = VultureEntity.this.m_5448_();
                Vec3 vec3d = livingentity.m_20299_(1.0f);
                VultureEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.5);
            }

            public void m_8037_() {
                LivingEntity livingentity = VultureEntity.this.m_5448_();
                if (VultureEntity.this.m_20191_().m_82381_(livingentity.m_20191_())) {
                    VultureEntity.this.m_7327_((Entity)livingentity);
                } else {
                    double d0 = VultureEntity.this.m_20280_((Entity)livingentity);
                    if (d0 < 16.0) {
                        Vec3 vec3d = livingentity.m_20299_(1.0f);
                        VultureEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.5);
                    }
                }
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new FollowMobGoal((Mob)this, 1.0, 10.0f, 5.0f));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return 1.8 * (double)(this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_());
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(6, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(7, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(9, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, entity -> entity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("redev:vulture_attacks")))));
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (target instanceof TamableAnimal) {
            TamableAnimal tamed = (TamableAnimal)target;
            return !tamed.m_21824_() || tamed.m_269323_() != owner;
        }
        if (target instanceof Player && owner instanceof Player) {
            return ((Player)owner).m_7099_((Player)target);
        }
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_BUNDLE, (Object)false);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("HasBundle", this.hasBundle());
        ListTag itemsTag = new ListTag();
        for (ItemStack item : this.inventory) {
            CompoundTag itemTag = new CompoundTag();
            item.m_41739_(itemTag);
            itemsTag.add((Object)itemTag);
        }
        tag.m_128365_("Inventory", (Tag)itemsTag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setHasBundle(tag.m_128471_("HasBundle"));
        this.inventory.clear();
        ListTag itemsTag = tag.m_128437_("Inventory", 10);
        for (int i = 0; i < itemsTag.size() && i < this.inventory.size(); ++i) {
            this.inventory.set(i, (Object)ItemStack.m_41712_((CompoundTag)itemsTag.m_128728_(i)));
        }
    }

    public boolean hasBundle() {
        return (Boolean)this.f_19804_.m_135370_(HAS_BUNDLE);
    }

    public void setHasBundle(boolean hasBundle) {
        this.f_19804_.m_135381_(HAS_BUNDLE, (Object)hasBundle);
    }

    public boolean addItemToInventory(ItemStack itemStack) {
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (!((ItemStack)this.inventory.get(i)).m_41619_()) continue;
            this.inventory.set(i, (Object)itemStack.m_41777_());
            return true;
        }
        return false;
    }

    public void dropInventoryItems() {
        for (ItemStack item : this.inventory) {
            if (item.m_41619_()) continue;
            this.m_19983_(item);
        }
        this.inventory.clear();
    }

    public boolean m_7327_(Entity target) {
        boolean flag = super.m_7327_(target);
        if (flag && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            if (!this.m_9236_().f_46443_) {
                this.dropRandomLoot(livingTarget);
            }
        }
        return flag;
    }

    private void dropRandomLoot(LivingEntity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            LootParams lootParams;
            ServerLevel serverLevel = (ServerLevel)level;
            ResourceLocation lootTableLocation = entity.m_5743_();
            LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(lootTableLocation);
            ObjectArrayList loot = lootTable.m_287195_(lootParams = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)entity).m_287286_(LootContextParams.f_81457_, (Object)entity.m_269291_().m_269333_((LivingEntity)this)).m_287235_(LootContextParamSets.f_81415_));
            if (!loot.isEmpty()) {
                ItemStack randomLoot = (ItemStack)loot.get(serverLevel.m_213780_().m_188503_(loot.size()));
                entity.m_19983_(randomLoot);
            }
        }
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.dropInventoryItems();
        if (this.hasBundle()) {
            this.m_19983_(new ItemStack((ItemLike)Items.f_151058_));
            this.setHasBundle(false);
        }
    }

    public double m_6048_() {
        return super.m_6048_() + -0.8;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.phantom.ambient"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.phantom.flap")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.phantom.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.phantom.death"));
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        return false;
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof SpawnEggItem) {
            return super.m_6071_(player, hand);
        }
        if (this.m_9236_().f_46443_) {
            return this.m_21824_() && this.m_21830_((LivingEntity)player) || this.m_6898_(itemstack) ? InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()) : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)player)) {
                if (item == Items.f_42574_) {
                    this.dropInventoryItems();
                    if (this.hasBundle()) {
                        this.m_19983_(new ItemStack((ItemLike)Items.f_151058_));
                        this.setHasBundle(false);
                    }
                    this.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
                if (item.m_41472_() && this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(player, hand, itemstack);
                    this.m_5634_(item.m_41473_().m_38744_());
                    return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
                if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(player, hand, itemstack);
                    this.m_5634_(4.0f);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
                if (item == Items.f_151058_ && !this.hasBundle()) {
                    this.setHasBundle(true);
                    this.m_142075_(player, hand, itemstack);
                    this.m_5496_(SoundEvents.f_11678_, 1.0f, 1.0f);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
                if (this.hasBundle() && !this.m_6898_(itemstack)) {
                    if (this.addItemToInventory(itemstack)) {
                        player.m_21008_(hand, ItemStack.f_41583_);
                        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                    }
                    return InteractionResult.FAIL;
                }
            }
        } else if (this.m_6898_(itemstack)) {
            this.m_142075_(player, hand, itemstack);
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            this.m_21530_();
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        VultureEntity retval = (VultureEntity)((EntityType)RedevModEntities.VULTURE.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42583_)}).test(stack);
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_20242_(true);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)RedevModEntities.VULTURE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_) && world.m_45524_(pos, 0) > 8);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 8.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22280_, 0.5);
        return builder;
    }
}

