/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.item;

import java.util.UUID;
import net.mcreator.redev.init.RedevModItems;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class ArmadilloShellItem
extends ArmorItem {
    public static final UUID SNEAK_ARMOR_UUID = UUID.fromString("5a07b21c-90ff-4d28-bb3e-0123b1234567");

    public ArmadilloShellItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_266425_(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.m_266308_().m_20749_()] * 29;
            }

            public int m_7366_(ArmorItem.Type type) {
                return (new int[]{0, 0, 7, 0})[type.m_266308_().m_20749_()];
            }

            public int m_6646_() {
                return 9;
            }

            public SoundEvent m_7344_() {
                return SoundEvents.f_271165_;
            }

            public Ingredient m_6230_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)RedevModItems.ARMADILLO_SCUTE.get())});
            }

            public String m_6082_() {
                return "armadillo_shell";
            }

            public float m_6651_() {
                return 1.0f;
            }

            public float m_6649_() {
                return 0.05f;
            }
        }, type, properties);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (level.f_46443_ || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        ItemStack chestItem = living.m_6844_(EquipmentSlot.CHEST);
        boolean isWearingArmadillo = chestItem.m_41720_() instanceof ArmadilloShellItem;
        AttributeInstance attr = living.m_21051_(Attributes.f_22284_);
        if (attr == null) {
            return;
        }
        boolean hasModifier = attr.m_22122_().stream().anyMatch(mod -> mod.m_22209_().equals(SNEAK_ARMOR_UUID));
        if (isWearingArmadillo && living.m_6047_()) {
            if (!hasModifier) {
                attr.m_22118_(new AttributeModifier(SNEAK_ARMOR_UUID, "Armadillo Sneak Armor Bonus", 3.0, AttributeModifier.Operation.ADDITION));
            }
        } else if (hasModifier) {
            attr.m_22120_(SNEAK_ARMOR_UUID);
        }
    }

    public static class Chestplate
    extends ArmadilloShellItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "redev:textures/models/armor/armadillo_shell__layer_1.png";
        }
    }
}

