/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.item;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class InvasionHornItem
extends Item {
    private static final String NBT_MODE = "horn_mode";

    public InvasionHornItem() {
        super(new Item.Properties().m_41487_(1).m_41486_().m_41497_(Rarity.RARE));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private Predicate<Mob> getValidPiglinPredicate(Player player) {
        return mob -> {
            TamableAnimal tamable;
            return mob instanceof Piglin && !(mob instanceof PiglinBrute) && !(mob instanceof ZombifiedPiglin) || mob instanceof TamableAnimal && (tamable = (TamableAnimal)mob).m_21830_((LivingEntity)player) || mob.m_7307_((Entity)player);
        };
    }

    private Mode getHornMode(ItemStack stack) {
        try {
            String modeStr = stack.m_41784_().m_128461_(NBT_MODE);
            return modeStr.isEmpty() ? Mode.TARGET : Mode.valueOf(modeStr);
        }
        catch (IllegalArgumentException e) {
            return Mode.TARGET;
        }
    }

    private void spawnHornParticles(ServerLevel level, LivingEntity entity) {
        for (int i = 0; i < 10; ++i) {
            double xOffset = (level.f_46441_.m_188500_() - 0.5) * (double)entity.m_20205_() * 2.0;
            double yOffset = level.f_46441_.m_188500_() * (double)entity.m_20206_();
            double zOffset = (level.f_46441_.m_188500_() - 0.5) * (double)entity.m_20205_() * 2.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, entity.m_20185_() + xOffset, entity.m_20186_() + yOffset, entity.m_20189_() + zOffset, 1, 0.0, 0.0, 0.0, 0.02);
        }
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        return UseAnim.TOOT_HORN;
    }

    public int m_8105_(ItemStack itemstack) {
        return 1;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        ItemStack stack = context.m_43722_();
        if (player != null && player.m_6144_() && !level.f_46443_) {
            CompoundTag tag = stack.m_41784_();
            Mode current = this.getHornMode(stack);
            Mode next = current.next();
            tag.m_128359_(NBT_MODE, next.name());
            player.m_5661_((Component)Component.m_237113_((String)("Horn mode: " + next.name())), true);
            player.m_21011_(context.m_43724_(), true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack stack = player.m_21120_(hand);
        List piglins = serverLevel.m_6443_(Mob.class, player.m_20191_().m_82400_(16.0), this.getValidPiglinPredicate(player));
        for (Mob piglin : piglins) {
            piglin.m_21573_().m_5624_((Entity)player, 1.25);
        }
        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundEvents.f_12355_.get(), SoundSource.PLAYERS, 256.0f, 1.25f);
        player.m_36335_().m_41524_((Item)this, 20);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @SubscribeEvent
    public void onEntityRightClick(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        if (!(stack.m_41720_() instanceof InvasionHornItem)) {
            return;
        }
        Player player = event.getEntity();
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Entity entity = event.getTarget();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        Mode mode = this.getHornMode(stack);
        List piglins = serverLevel.m_6443_(Mob.class, player.m_20191_().m_82400_(16.0), this.getValidPiglinPredicate(player));
        switch (mode) {
            case TARGET: {
                for (Mob piglin : piglins) {
                    piglin.m_6710_(target);
                    piglin.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)target);
                    piglin.m_6274_().m_21879_(MemoryModuleType.f_26334_, (Object)target.m_20148_());
                    this.spawnHornParticles(serverLevel, (LivingEntity)player);
                }
                break;
            }
            case SPREAD: {
                List sameTypeTargets = serverLevel.m_6443_(LivingEntity.class, target.m_20191_().m_82400_(8.0), e -> e.m_6095_() == target.m_6095_() && e != player && e != target && e.m_6084_());
                sameTypeTargets.add(target);
                for (Mob piglin : piglins) {
                    if (sameTypeTargets.isEmpty()) continue;
                    LivingEntity selected = (LivingEntity)sameTypeTargets.get(serverLevel.f_46441_.m_188503_(sameTypeTargets.size()));
                    piglin.m_6710_(selected);
                    piglin.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)selected);
                    piglin.m_6274_().m_21879_(MemoryModuleType.f_26334_, (Object)selected.m_20148_());
                    this.spawnHornParticles(serverLevel, (LivingEntity)piglin);
                }
                break;
            }
        }
        player.m_21011_(event.getHand(), true);
        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(event.getHand()));
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundEvents.f_12355_.get(), SoundSource.PLAYERS, 256.0f, 1.25f);
        player.m_36335_().m_41524_((Item)this, 20);
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
    }

    public static enum Mode {
        TARGET,
        SPREAD;


        public Mode next() {
            return Mode.values()[(this.ordinal() + 1) % Mode.values().length];
        }
    }
}

