/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.item;

import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.extensions.IForgeItemStack;

public class ToolboxItem
extends Item {
    private static final String TAG_ITEMS = "Items";
    private static final int MAX_ITEMS = 5;
    private static final String TAG_SELECTED = "SelectedSlot";
    private static final int BAR_COLOR = Mth.m_14159_((float)0.93f, (float)0.86f, (float)0.22f);
    private static final ThreadLocal<ItemStack> CURRENT_CONTEXT_STACK = new ThreadLocal();

    public ToolboxItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.COMMON));
    }

    private static boolean isValidItem(ItemStack stack) {
        return stack.m_41741_() == 1;
    }

    private static Stream<ItemStack> getContents(ItemStack toolbox) {
        CompoundTag tag = toolbox.m_41783_();
        if (tag == null || !tag.m_128441_(TAG_ITEMS)) {
            return Stream.empty();
        }
        ListTag items = tag.m_128437_(TAG_ITEMS, 10);
        return items.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    private static ListTag getItemList(ItemStack toolbox) {
        CompoundTag tag = toolbox.m_41784_();
        if (!tag.m_128441_(TAG_ITEMS)) {
            tag.m_128365_(TAG_ITEMS, (Tag)new ListTag());
        }
        return tag.m_128437_(TAG_ITEMS, 10);
    }

    private static int getItemCount(ItemStack toolbox) {
        return (int)ToolboxItem.getContents(toolbox).count();
    }

    private static boolean addItem(ItemStack toolbox, ItemStack toAdd) {
        if (!ToolboxItem.isValidItem(toAdd) || ToolboxItem.getItemCount(toolbox) >= 5) {
            return false;
        }
        ListTag itemList = ToolboxItem.getItemList(toolbox);
        ItemStack newStack = toAdd.m_255036_(1);
        CompoundTag tag = new CompoundTag();
        newStack.m_41739_(tag);
        itemList.add((Object)tag);
        return true;
    }

    private static Optional<ItemStack> removeLast(ItemStack toolbox) {
        ListTag list = ToolboxItem.getItemList(toolbox);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag lastTag = list.m_128728_(list.size() - 1);
        list.remove(list.size() - 1);
        if (list.isEmpty()) {
            toolbox.m_41749_(TAG_ITEMS);
        }
        return Optional.of(ItemStack.m_41712_((CompoundTag)lastTag));
    }

    private static boolean dropContents(ItemStack toolbox, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            ToolboxItem.getContents(toolbox).forEach(stack -> player.m_36176_(stack, true));
        }
        toolbox.m_41749_(TAG_ITEMS);
        return true;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        NonNullList contents = NonNullList.m_122779_();
        ToolboxItem.getContents(stack).forEach(arg_0 -> contents.add(arg_0));
        return Optional.of(new BundleTooltip(contents, ToolboxItem.getItemCount(stack)));
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)(ToolboxItem.getItemCount(stack) + "/5")).m_130940_(ChatFormatting.GRAY));
    }

    public boolean m_142522_(ItemStack stack) {
        return ToolboxItem.getItemCount(stack) > 0;
    }

    public int m_142158_(ItemStack stack) {
        return Math.min(1 + 12 * ToolboxItem.getItemCount(stack) / 5, 13);
    }

    public int m_142159_(ItemStack stack) {
        return BAR_COLOR;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack toolbox = player.m_21120_(hand);
        if (player.m_6144_()) {
            List<ItemStack> contents = ToolboxItem.getContents(toolbox).toList();
            if (!contents.isEmpty()) {
                int current = ToolboxItem.getSelectedIndex(toolbox);
                int next = (current + 1) % contents.size();
                ToolboxItem.setSelectedIndex(toolbox, next);
                if (level.f_46443_) {
                    player.m_5661_((Component)Component.m_237113_((String)("Selected: " + contents.get(next).m_41611_().getString())), true);
                }
                this.playSelectSound((Entity)player);
                return InteractionResultHolder.m_19092_((Object)toolbox, (boolean)level.f_46443_);
            }
            return InteractionResultHolder.m_19098_((Object)toolbox);
        }
        if (ToolboxItem.dropContents(toolbox, player)) {
            this.playDropSound((Entity)player);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)toolbox, (boolean)level.f_46443_);
        }
        return InteractionResultHolder.m_19100_((Object)toolbox);
    }

    public boolean m_142207_(ItemStack toolbox, Slot slot, ClickAction action, Player player) {
        if (toolbox.m_41613_() != 1 || action != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack target = slot.m_7993_();
        if (target.m_41619_()) {
            ToolboxItem.removeLast(toolbox).ifPresent(stack -> slot.m_150659_(stack));
            this.playRemoveSound((Entity)player);
        } else if (ToolboxItem.isValidItem(target) && ToolboxItem.addItem(toolbox, target)) {
            slot.m_6201_(1);
            this.playInsertSound((Entity)player);
        }
        return true;
    }

    public boolean m_142305_(ItemStack toolbox, ItemStack stack, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (toolbox.m_41613_() != 1 || action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (stack.m_41619_()) {
            ToolboxItem.removeLast(toolbox).ifPresent(s -> {
                this.playRemoveSound((Entity)player);
                access.m_142104_(s);
            });
        } else if (ToolboxItem.isValidItem(stack) && ToolboxItem.addItem(toolbox, stack)) {
            stack.m_41774_(1);
            this.playInsertSound((Entity)player);
        }
        return true;
    }

    private static int getSelectedIndex(ItemStack toolbox) {
        return toolbox.m_41784_().m_128451_(TAG_SELECTED);
    }

    private static void setSelectedIndex(ItemStack toolbox, int index) {
        toolbox.m_41784_().m_128405_(TAG_SELECTED, index);
    }

    private static Optional<ItemStack> getSelectedItem(ItemStack toolbox) {
        List<ItemStack> contents = ToolboxItem.getContents(toolbox).toList();
        int index = ToolboxItem.getSelectedIndex(toolbox);
        if (index >= 0 && index < contents.size()) {
            return Optional.of(contents.get(index));
        }
        return Optional.empty();
    }

    private void playSelectSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_11871_, 0.7f, 1.4f);
    }

    public float m_8102_(ItemStack toolbox, BlockState state) {
        return ToolboxItem.getSelectedItem(toolbox).map(stack -> Float.valueOf(stack.m_41691_(state))).orElse(Float.valueOf(super.m_8102_(toolbox, state))).floatValue();
    }

    public boolean m_7579_(ItemStack toolbox, LivingEntity target, LivingEntity attacker) {
        if (!(attacker instanceof Player)) {
            return false;
        }
        Player player = (Player)attacker;
        return ToolboxItem.getSelectedItem(toolbox).map(selected -> {
            selected.m_41640_(target, player);
            selected.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(player.m_7655_()));
            ToolboxItem.updateStoredItem(toolbox, selected);
            return true;
        }).orElse(false);
    }

    public boolean m_6813_(ItemStack toolbox, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        return ToolboxItem.getSelectedItem(toolbox).map(selected -> {
            selected.m_41686_(level, state, pos, player);
            selected.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(player.m_7655_()));
            ToolboxItem.updateStoredItem(toolbox, selected);
            return true;
        }).orElse(false);
    }

    private static void updateStoredItem(ItemStack toolbox, ItemStack updatedItem) {
        ListTag list = ToolboxItem.getItemList(toolbox);
        int index = ToolboxItem.getSelectedIndex(toolbox);
        if (index >= 0 && index < list.size()) {
            CompoundTag newTag = new CompoundTag();
            updatedItem.m_41739_(newTag);
            list.set(index, (Tag)newTag);
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, level, entity, slot, selected);
        if (!level.f_46443_ && selected && entity instanceof Player) {
            CURRENT_CONTEXT_STACK.set(stack);
        }
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int count) {
        super.m_5929_(level, entity, stack, count);
        CURRENT_CONTEXT_STACK.set(stack);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        Item item2;
        ItemStack contextStack;
        if (slot == EquipmentSlot.MAINHAND && (contextStack = CURRENT_CONTEXT_STACK.get()) != null && (item2 = contextStack.m_41720_()) instanceof ToolboxItem) {
            ToolboxItem toolboxItem = (ToolboxItem)item2;
            return ToolboxItem.getSelectedItem(contextStack).map(item -> item.m_41638_(slot)).orElse(super.m_7167_(slot));
        }
        return super.m_7167_(slot);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return ToolboxItem.getSelectedItem(stack).map(tool -> tool.m_41735_(state)).orElse(false);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        super.m_5551_(stack, level, entity, timeLeft);
        CURRENT_CONTEXT_STACK.remove();
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return ToolboxItem.getSelectedItem(stack).map(item -> item.getEnchantmentLevel(enchantment)).orElse(0);
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        return ToolboxItem.getSelectedItem(stack).map(IForgeItemStack::getAllEnchantments).orElse(Collections.emptyMap());
    }

    public boolean m_5812_(ItemStack stack) {
        return ToolboxItem.getSelectedItem(stack).map(ItemStack::m_41793_).orElse(false);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 1.0f);
    }

    private void playRemoveSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 1.0f);
    }

    private void playDropSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184214_, 0.8f, 1.0f);
    }

    public void m_142023_(ItemEntity itemEntity) {
        ItemUtils.m_150952_((ItemEntity)itemEntity, ToolboxItem.getContents(itemEntity.m_32055_()));
    }
}

