/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class WrenchItem
extends Item {
    public WrenchItem() {
        super(new Item.Properties().m_41503_(256).m_41497_(Rarity.COMMON));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState state = world.m_8055_(pos);
        BlockState rotatedState = this.getNextRotatedState(state);
        if (rotatedState != null) {
            world.m_5594_(null, pos, SoundEvents.f_12055_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_7731_(pos, rotatedState, 3);
            ItemStack stack = context.m_43722_();
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private BlockState getNextRotatedState(BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            Direction currentFacing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            Direction nextFacing = this.rotateDirectionClockwise(currentFacing);
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)nextFacing);
        }
        if (state.m_60734_() instanceof RotatedPillarBlock) {
            Direction.Axis currentAxis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_);
            Direction.Axis nextAxis = this.cycleAxis(currentAxis);
            return (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)nextAxis);
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            Direction currentFacing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            Direction nextFacing = this.rotateHorizontalClockwise(currentFacing);
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)nextFacing);
        }
        return null;
    }

    private Direction rotateDirectionClockwise(Direction current) {
        switch (current) {
            case NORTH: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.NORTH;
            }
            case UP: {
                return Direction.DOWN;
            }
            case DOWN: {
                return Direction.UP;
            }
        }
        return current;
    }

    private Direction rotateHorizontalClockwise(Direction current) {
        switch (current) {
            case NORTH: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.NORTH;
            }
        }
        return current;
    }

    private Direction.Axis cycleAxis(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return Direction.Axis.Y;
            }
            case Y: {
                return Direction.Axis.Z;
            }
            case Z: {
                return Direction.Axis.X;
            }
        }
        return axis;
    }
}

