/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.world.feature.configured;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.phys.Vec3;

public class CustomFeatureWallFeature
extends Feature<Configuration> {
    public CustomFeatureWallFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Configuration> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        Configuration config = (Configuration)context.m_159778_();
        Vec3 direction = new Vec3(1.0, 0.0, 0.0);
        BlockPos current = origin;
        ArrayList<BlockPos> pathPoints = new ArrayList<BlockPos>();
        int steps = config.length().m_214085_(random);
        if (steps <= 0) {
            return false;
        }
        int surfaceY = world.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, origin).m_123342_();
        BlockPos first = new BlockPos(origin.m_123341_(), surfaceY, origin.m_123343_());
        pathPoints.add(first);
        for (int i = 1; i < steps; ++i) {
            double dx = direction.f_82479_ + (random.m_188500_() - 0.5) * (double)config.curveStrength();
            double dz = direction.f_82481_ + (random.m_188500_() - 0.5) * (double)config.curveStrength();
            double len = Math.sqrt(dx * dx + dz * dz);
            direction = new Vec3(dx / len, 0.0, dz / len);
            int stepX = (int)Math.round(direction.f_82479_);
            int stepZ = (int)Math.round(direction.f_82481_);
            BlockPos step = current.m_7918_(stepX, 0, stepZ);
            int y = world.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, step).m_123342_();
            BlockPos ground = new BlockPos(step.m_123341_(), y - 1, step.m_123343_());
            if (!world.m_8055_(ground).m_60815_()) continue;
            current = new BlockPos(step.m_123341_(), y, step.m_123343_());
            pathPoints.add(current.m_7949_());
        }
        for (BlockPos pos : pathPoints) {
            ((ConfiguredFeature)config.feature().m_203334_()).m_224953_(world, context.m_159775_(), random, pos);
        }
        return true;
    }

    public record Configuration(Holder<ConfiguredFeature<?, ?>> feature, IntProvider length, float curveStrength) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConfiguredFeature.f_65374_.fieldOf("feature").forGetter(Configuration::feature), (App)IntProvider.f_146531_.fieldOf("length").forGetter(Configuration::length), (App)Codec.FLOAT.fieldOf("curve_strength").forGetter(Configuration::curveStrength)).apply((Applicative)instance, Configuration::new));
    }
}

