/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.world.feature.trunkplacer;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.mcreator.redev.custom.init.RedevModTrunkTypes;
import net.mcreator.redev.init.RedevModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class PalmTrunkPlacer
extends TrunkPlacer {
    public static final Codec<PalmTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> PalmTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, PalmTrunkPlacer::new));

    public PalmTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)RedevModTrunkTypes.PALM_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> trunkConsumer, RandomSource random, int height, BlockPos pos, TreeConfiguration config) {
        ArrayList<FoliagePlacer.FoliageAttachment> foliageAttachments = new ArrayList<FoliagePlacer.FoliageAttachment>();
        BlockPos currentPos = pos;
        int halfway = (height + 1) / 2;
        for (int y = 0; y < height; ++y) {
            BlockPos trunkPos = currentPos.m_6630_(y);
            if (y == height - 1) {
                trunkConsumer.accept(trunkPos, ((Block)RedevModBlocks.PALM_CROWN.get()).m_49966_());
                this.placeCoconut(trunkConsumer, random, trunkPos.m_7918_(1, 0, 0), Direction.EAST);
                this.placeCoconut(trunkConsumer, random, trunkPos.m_7918_(-1, 0, 0), Direction.WEST);
                this.placeCoconut(trunkConsumer, random, trunkPos.m_7918_(0, 0, 1), Direction.SOUTH);
                this.placeCoconut(trunkConsumer, random, trunkPos.m_7918_(0, 0, -1), Direction.NORTH);
            } else {
                this.m_226187_(reader, trunkConsumer, random, trunkPos, config);
            }
            if (y != halfway - 1) continue;
            currentPos = currentPos.m_121945_(this.getRandomDirection(random));
        }
        foliageAttachments.add(new FoliagePlacer.FoliageAttachment(currentPos.m_6630_(height), 0, false));
        return foliageAttachments;
    }

    private void placeCoconut(BiConsumer<BlockPos, BlockState> trunkConsumer, RandomSource random, BlockPos coconutPos, Direction facing) {
        if (random.m_188501_() < 0.25f) {
            BlockState coconutState = ((Block)RedevModBlocks.WILD_COCONUT.get()).m_49966_();
            if (coconutState.m_61138_((Property)BlockStateProperties.f_61372_)) {
                coconutState = (BlockState)coconutState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing);
            }
            if (coconutState.m_61138_((Property)BlockStateProperties.f_61376_)) {
                coconutState = (BlockState)coconutState.m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)AttachFace.FLOOR);
            }
            trunkConsumer.accept(coconutPos, coconutState);
        }
    }

    private Direction getRandomDirection(RandomSource random) {
        return Direction.Plane.HORIZONTAL.m_235690_(random);
    }
}

