/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.block;

import com.google.common.collect.ImmutableList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CandleStumpBlock
extends AbstractCandleBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public CandleStumpBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_154653_).m_60978_(1.0f).m_60955_().m_60953_(state -> (Boolean)state.m_61143_((Property)LIT) != false ? 8 : 0).m_60924_((s, r, p) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected Iterable<Vec3> m_142199_(BlockState state) {
        return ImmutableList.of((Object)new Vec3(0.5, 0.9375, 0.5));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_150110_().f_35938_ && player.m_21120_(hand).m_41619_() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            CandleStumpBlock.m_151899_((Player)player, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            Vec3 vec = new Vec3(0.5, 0.9375, 0.5).m_82520_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            CandleStumpBlock.addParticles(level, vec, random);
        }
    }

    public static void addParticles(Level level, Vec3 vec, RandomSource random) {
        float chance = random.m_188501_();
        if (chance < 0.3f) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0);
            if (chance < 0.17f) {
                level.m_7785_(vec.f_82479_ + 0.5, vec.f_82480_ + 0.5, vec.f_82481_ + 0.5, SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f + random.m_188501_(), random.m_188501_() * 0.7f + 0.3f, false);
            }
        }
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluid = ctx.m_43725_().m_6425_(ctx.m_8083_());
        boolean waterlogged = fluid.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, dir, neighbor, level, pos, neighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluid) {
        if (!((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && fluid.m_76152_() == Fluids.f_76193_) {
            BlockState newState = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                CandleStumpBlock.m_151899_(null, (BlockState)newState, (LevelAccessor)world, (BlockPos)pos);
            } else {
                world.m_7731_(pos, newState, 3);
            }
            world.m_186469_(pos, fluid.m_76152_(), fluid.m_76152_().m_6718_((LevelReader)world));
            return true;
        }
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

