/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.block;

import javax.annotation.Nullable;
import net.mcreator.redev.init.RedevModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PineappleCropBlock
extends Block
implements BonemealableBlock {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)3);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)18.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)24.0, (double)14.0)};

    public PineappleCropBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60918_(SoundType.f_56740_).m_60913_(0.2f, 0.2f).m_60910_().m_60977_().m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) <= 3;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos above;
        if (!PineappleCropBlock.sufficientLight((LevelReader)level, pos)) {
            return;
        }
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age < 3) {
            float growthSpeed = this.getGrowthSpeed((BlockGetter)level, pos);
            if (random.m_188503_((int)(25.0f / growthSpeed) + 1) == 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            }
        } else if (random.m_188503_(26) == 0 && level.m_46859_(above = pos.m_7494_())) {
            level.m_7731_(pos, ((Block)RedevModBlocks.PINEAPPLE_BLOCK.get()).m_49966_(), 3);
            level.m_7731_(above, ((Block)RedevModBlocks.PINEAPPLE_CROWN.get()).m_49966_(), 3);
        }
    }

    private float getGrowthSpeed(BlockGetter level, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        BlockState soil = level.m_8055_(below);
        return soil.m_60713_(Blocks.f_50093_) && soil.m_60734_().isFertile(soil, level, below) ? 3.0f : 1.0f;
    }

    private static boolean sufficientLight(LevelReader level, BlockPos pos) {
        return level.m_45524_(pos, 0) >= 8 || level.m_45527_(pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.m_61143_((Property)AGE)];
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState below = level.m_8055_(pos.m_7495_());
        return below.m_60713_(Blocks.f_50093_) || below.m_204336_(BlockTags.f_144274_);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        return !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : state;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.m_49966_();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack held = player.m_21120_(hand);
        if ((Integer)state.m_61143_((Property)AGE) == 3 && held.m_41720_() == Items.f_42574_) {
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            PineappleCropBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)RedevModBlocks.PINEAPPLE.get()));
            level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 1.0f);
            held.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age < 3) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
        } else {
            BlockPos above = pos.m_7494_();
            if (level.m_46859_(above)) {
                level.m_7731_(pos, ((Block)RedevModBlocks.PINEAPPLE_BLOCK.get()).m_49966_(), 3);
                level.m_7731_(above, ((Block)RedevModBlocks.PINEAPPLE_CROWN.get()).m_49966_(), 3);
            }
        }
    }
}

