/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.block;

import net.mcreator.redev.init.RedevModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class PumiceBlock
extends Block {
    public static final int MAX_DEPTH = 6;
    public static final int MAX_COUNT = 64;
    private static final Direction[] ALL_DIRECTIONS = Direction.values();

    public PumiceBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_154659_).m_60978_(1.0f).m_60999_());
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_())) {
            this.tryAbsorbLava(level, pos);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        this.tryAbsorbLava(level, pos);
        super.m_6861_(state, level, pos, neighborBlock, fromPos, isMoving);
    }

    protected void tryAbsorbLava(Level level, BlockPos pos) {
        if (this.removeLavaBreadthFirstSearch(level, pos)) {
            level.m_7731_(pos, ((Block)RedevModBlocks.BUBBLING_PUMICE.get()).m_49966_(), 2);
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)Blocks.f_49991_.m_49966_()));
            level.m_5594_(null, pos, SoundEvents.f_12031_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private boolean removeLavaBreadthFirstSearch(Level level, BlockPos origin) {
        BlockState spongeState = level.m_8055_(origin);
        return BlockPos.m_276833_((BlockPos)origin, (int)6, (int)64, (currentPos, nextConsumer) -> {
            for (Direction direction : ALL_DIRECTIONS) {
                nextConsumer.accept(currentPos.m_121945_(direction));
            }
        }, targetPos -> {
            BucketPickup bucketPickup;
            if (targetPos.equals((Object)origin)) {
                return true;
            }
            BlockState targetState = level.m_8055_(targetPos);
            FluidState fluidState = level.m_6425_(targetPos);
            if (!fluidState.m_192917_((Fluid)Fluids.f_76195_)) {
                return false;
            }
            Block block = targetState.m_60734_();
            if (block instanceof BucketPickup && !(bucketPickup = (BucketPickup)block).m_142598_((LevelAccessor)level, targetPos, targetState).m_41619_()) {
                return true;
            }
            if (targetState.m_60734_() instanceof LiquidBlock) {
                level.m_7731_(targetPos, Blocks.f_50016_.m_49966_(), 3);
            } else {
                BlockEntity be = targetState.m_155947_() ? level.m_7702_(targetPos) : null;
                PumiceBlock.m_49892_((BlockState)targetState, (LevelAccessor)level, (BlockPos)targetPos, (BlockEntity)be);
                level.m_7731_(targetPos, Blocks.f_50016_.m_49966_(), 3);
            }
            return true;
        }) > 1;
    }
}

