/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.block.entity;

import java.util.Map;
import net.mcreator.redev.EchoingChamberMenuMenu;
import net.mcreator.redev.init.RedevModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class EchoingChamberBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
MenuProvider {
    private NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])Direction.values());
    private boolean transferInProgress = false;
    private int tickCounter = 0;
    private final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> EchoingChamberBlockEntity.this.tickCounter;
                case 1 -> {
                    if (EchoingChamberBlockEntity.this.transferInProgress) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    EchoingChamberBlockEntity.this.tickCounter = value;
                    break;
                }
                case 1: {
                    EchoingChamberBlockEntity.this.transferInProgress = value != 0;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public EchoingChamberBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RedevModBlockEntities.ECHOING_CHAMBER.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EchoingChamberBlockEntity be) {
        if (level.f_46443_) {
            return;
        }
        ItemStack source = (ItemStack)be.stacks.get(0);
        ItemStack shard = (ItemStack)be.stacks.get(1);
        ItemStack target = (ItemStack)be.stacks.get(2);
        if (!be.transferInProgress) {
            boolean canStart;
            boolean isMatchingItem = source.m_41720_().getClass() == target.m_41720_().getClass();
            boolean isBookTarget = target.m_150930_(Items.f_42517_);
            boolean bl = canStart = !source.m_41619_() && source.m_41793_() && !shard.m_41619_() && shard.m_150930_(Items.f_220224_) && !target.m_41619_() && !target.m_41793_() && (isMatchingItem || isBookTarget);
            if (canStart) {
                shard.m_41774_(1);
                if (shard.m_41619_()) {
                    be.stacks.set(1, (Object)ItemStack.f_41583_);
                }
                be.transferInProgress = true;
                be.tickCounter = 0;
                be.m_6596_();
                level.m_7260_(pos, be.m_58900_(), be.m_58900_(), 3);
            }
        }
        if (be.transferInProgress) {
            if (!level.f_46443_ && level.f_46441_.m_188501_() < 0.25f) {
                double px = (double)pos.m_123341_() + (5.0 + level.f_46441_.m_188500_() * 6.0) / 16.0;
                double py = (double)pos.m_123342_() + 0.8125;
                double pz = (double)pos.m_123343_() + (5.0 + level.f_46441_.m_188500_() * 6.0) / 16.0;
                double motionY = 0.01;
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_235900_, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (source.m_41619_() || target.m_41619_() || !source.m_41793_()) {
                be.transferInProgress = false;
                return;
            }
            if (++be.tickCounter >= 40) {
                be.tickCounter = 0;
                Map sourceMap = EnchantmentHelper.m_44831_((ItemStack)source);
                if (!sourceMap.isEmpty()) {
                    Enchantment ench = (Enchantment)sourceMap.keySet().iterator().next();
                    int level1 = (Integer)sourceMap.remove(ench);
                    EnchantmentHelper.m_44865_((Map)sourceMap, (ItemStack)source);
                    if (target.m_150930_(Items.f_42517_)) {
                        ItemStack enchanted = new ItemStack((ItemLike)Items.f_42690_);
                        EnchantmentHelper.m_44865_(Map.of(ench, level1), (ItemStack)enchanted);
                        be.stacks.set(2, (Object)enchanted);
                    } else {
                        Map targetMap = EnchantmentHelper.m_44831_((ItemStack)target);
                        targetMap.put(ench, level1);
                        EnchantmentHelper.m_44865_((Map)targetMap, (ItemStack)target);
                    }
                    level.m_5594_(null, pos, SoundEvents.f_215740_, SoundSource.BLOCKS, 1.0f, 1.1f);
                    be.m_6596_();
                    level.m_7260_(pos, be.m_58900_(), be.m_58900_(), 3);
                }
                if (EnchantmentHelper.m_44831_((ItemStack)source).isEmpty()) {
                    be.transferInProgress = false;
                }
            }
        }
    }

    public int getProgressScaled(int width) {
        if (!this.transferInProgress) {
            return 0;
        }
        return this.tickCounter * width / 40;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.stacks;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.stacks = items;
    }

    public int m_6643_() {
        return this.stacks.size();
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public AbstractContainerMenu m_6555_(int id, Inventory inv) {
        return new EchoingChamberMenuMenu(id, inv, this);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Echoing Chamber");
    }

    public Component m_6820_() {
        return Component.m_237113_((String)"echoing_chamber");
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tickCounter = tag.m_128451_("Progress");
        this.transferInProgress = tag.m_128471_("Active");
        this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.stacks);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Progress", this.tickCounter);
        tag.m_128379_("Active", this.transferInProgress);
        ContainerHelper.m_18973_((CompoundTag)tag, this.stacks);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && side != null && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handlers[side.ordinal()].cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public int[] m_7071_(Direction side) {
        return new int[]{0, 1, 2};
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return true;
    }

    public boolean m_7155_(int index, ItemStack stack, Direction side) {
        return true;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction side) {
        return true;
    }

    public ContainerData getDataAccess() {
        return this.data;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }
}

