/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.redev.client.model.Modelglare;
import net.mcreator.redev.entity.GlareEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class GlareRenderer
extends MobRenderer<GlareEntity, Modelglare<GlareEntity>> {
    private static final ResourceLocation NORMAL_TEXTURE = new ResourceLocation("redev:textures/entities/glare.png");
    private static final ResourceLocation ANGRY_TEXTURE = new ResourceLocation("redev:textures/entities/glare_angry.png");
    private static final ResourceLocation DAZED_TEXTURE = new ResourceLocation("redev:textures/entities/glare_dazed.png");
    private static final ResourceLocation NORMAL_EYES_TEXTURE = new ResourceLocation("redev:textures/entities/glare_normal.png");
    private static final ResourceLocation BERRIES_TEXTURE = new ResourceLocation("redev:textures/entities/glare_berries.png");

    public GlareRenderer(EntityRendererProvider.Context context) {
        super(context, new Modelglare(context.m_174023_(Modelglare.LAYER_LOCATION)), 0.6f);
        this.m_115326_((RenderLayer)new RenderLayer<GlareEntity, Modelglare<GlareEntity>>((RenderLayerParent)this){

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, GlareEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.m_9236_();
                BlockPos pos = entity.m_20183_();
                boolean isExposedToSky = world.m_45527_(pos);
                boolean isDayTime = world.m_46461_();
                int lightLevel = world.m_46803_(pos);
                ResourceLocation overlayTexture = null;
                overlayTexture = lightLevel <= 8 ? ANGRY_TEXTURE : (isExposedToSky && isDayTime ? DAZED_TEXTURE : (isExposedToSky && !isDayTime ? ANGRY_TEXTURE : NORMAL_EYES_TEXTURE));
                if (overlayTexture != null) {
                    VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110488_((ResourceLocation)overlayTexture));
                    ((Modelglare)this.m_117386_()).m_7695_(poseStack, vertexConsumer, light, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        });
        this.m_115326_((RenderLayer)new RenderLayer<GlareEntity, Modelglare<GlareEntity>>((RenderLayerParent)this){

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, GlareEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                if (((Boolean)entity.m_20088_().m_135370_(GlareEntity.GLARE_BERRIES)).booleanValue()) {
                    VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)BERRIES_TEXTURE));
                    int maxLight = 0xF000F0;
                    ((Modelglare)this.m_117386_()).m_7695_(poseStack, vertexConsumer, maxLight, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        });
    }

    public ResourceLocation getTextureLocation(GlareEntity entity) {
        return NORMAL_TEXTURE;
    }

    protected boolean isShaking(GlareEntity entity) {
        Level world = entity.m_9236_();
        BlockPos pos = entity.m_20183_();
        int lightLevel = world.m_46803_(pos);
        boolean isExposedToSky = world.m_45527_(pos);
        boolean isDayTime = world.m_46461_();
        return lightLevel <= 8 || isExposedToSky && !isDayTime;
    }
}

