/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.redev.client.model.Modelmunchkin;
import net.mcreator.redev.entity.MunchkinEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;

public class MunchkinRenderer
extends MobRenderer<MunchkinEntity, Modelmunchkin<MunchkinEntity>> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("redev:textures/entities/munchkin.png");
    private static final ResourceLocation DARK_TEXTURE = new ResourceLocation("redev:textures/entities/munchkin2.png");
    private static final ResourceLocation BADLANDS_TEXTURE = new ResourceLocation("redev:textures/entities/munchkin3.png");

    public MunchkinRenderer(EntityRendererProvider.Context context) {
        super(context, new Modelmunchkin(context.m_174023_(Modelmunchkin.LAYER_LOCATION)), 0.4f);
    }

    public void render(MunchkinEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        int feedingValue = entity.getFeedingValue();
        float scale = 1.0f + (float)feedingValue * 0.1f;
        scale = Math.min(scale, 4.0f);
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, scale);
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, bufferSource, light);
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(MunchkinEntity entity) {
        int variant = entity.getMunchkinVariant();
        if (variant == 1) {
            return DARK_TEXTURE;
        }
        if (variant == 2) {
            return BADLANDS_TEXTURE;
        }
        return DEFAULT_TEXTURE;
    }
}

