/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.redev.client.model.Modeloracle;
import net.mcreator.redev.entity.OracleEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class OracleRenderer
extends MobRenderer<OracleEntity, Modeloracle<OracleEntity>> {
    public OracleRenderer(EntityRendererProvider.Context context) {
        super(context, new Modeloracle(context.m_174023_(Modeloracle.LAYER_LOCATION)), 0.6f);
        this.m_115326_(new OracleGlowLayer((RenderLayerParent<OracleEntity, Modeloracle<OracleEntity>>)this));
        this.m_115326_(new OracleShakeLayer((RenderLayerParent<OracleEntity, Modeloracle<OracleEntity>>)this));
    }

    public ResourceLocation getTextureLocation(OracleEntity entity) {
        return new ResourceLocation("redev:textures/entities/oracle.png");
    }

    public class OracleGlowLayer
    extends RenderLayer<OracleEntity, Modeloracle<OracleEntity>> {
        private static final ResourceLocation GLOW_TEXTURE = new ResourceLocation("redev:textures/entities/oracle_emissive.png");

        public OracleGlowLayer(RenderLayerParent<OracleEntity, Modeloracle<OracleEntity>> parent) {
            super(parent);
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, OracleEntity oracle, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            int fadeProgress;
            float alpha;
            int fadeTicks;
            int waitTicks;
            int totalCycle;
            int tick = oracle.getGlowTick();
            int localTick = tick % (totalCycle = (waitTicks = 20) + (fadeTicks = 10));
            if (localTick >= waitTicks && (alpha = 1.0f - (float)(fadeProgress = localTick - waitTicks) / (float)fadeTicks) > 0.01f) {
                VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_234338_((ResourceLocation)GLOW_TEXTURE));
                ((Modeloracle)this.m_117386_()).m_7695_(poseStack, vertexConsumer, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
            }
        }
    }

    public class OracleShakeLayer
    extends RenderLayer<OracleEntity, Modeloracle<OracleEntity>> {
        private static final ResourceLocation TEXTURE = new ResourceLocation("redev:textures/entities/oracle.png");

        public OracleShakeLayer(RenderLayerParent<OracleEntity, Modeloracle<OracleEntity>> parent) {
            super(parent);
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, OracleEntity oracle, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            boolean isMoving;
            boolean bl = isMoving = oracle.m_20275_(oracle.f_19790_, oracle.f_19791_, oracle.f_19792_) > 0.0025;
            if (!isMoving) {
                return;
            }
            float intensity = 1.0f;
            float shakeAmount = intensity * 0.1f;
            float shakeX = (oracle.m_9236_().f_46441_.m_188501_() - 0.5f) * shakeAmount;
            float shakeZ = (oracle.m_9236_().f_46441_.m_188501_() - 0.5f) * shakeAmount;
            float shakeY = (oracle.m_9236_().f_46441_.m_188501_() - 0.5f) * shakeAmount;
            poseStack.m_252880_(shakeX, shakeY, shakeZ);
            poseStack.m_85841_(1.1f, 1.1f, 1.1f);
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE));
            ((Modeloracle)this.m_117386_()).m_7695_(poseStack, vertexConsumer, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.2f);
        }
    }
}

