/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.mcreator.redev.client.model.Modelpillar;
import net.mcreator.redev.entity.PillarEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;

public class PillarRenderer
extends MobRenderer<PillarEntity, Modelpillar<PillarEntity>> {
    private static final ResourceLocation NORMAL_TEXTURE = new ResourceLocation("redev:textures/entities/pillar.png");
    private static final ResourceLocation EXPLODING_TEXTURE = new ResourceLocation("redev:textures/entities/exploding_pillar.png");

    public PillarRenderer(EntityRendererProvider.Context context) {
        super(context, new Modelpillar(context.m_174023_(Modelpillar.LAYER_LOCATION)), 0.65f);
    }

    public ResourceLocation getTextureLocation(PillarEntity entity) {
        return entity.isExplosive() ? EXPLODING_TEXTURE : NORMAL_TEXTURE;
    }

    protected void setupRotations(PillarEntity entity, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
    }

    public void render(PillarEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (entity.isExplosive()) {
            float shakeX = this.getRandomShake(entity, partialTicks);
            float shakeZ = this.getRandomShake(entity, partialTicks);
            poseStack.m_85837_((double)shakeX, 0.0, (double)shakeZ);
        }
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private float getRandomShake(PillarEntity entity, float partialTicks) {
        int timer = entity.getExplosiveTimer();
        if (timer <= 0) {
            return 0.0f;
        }
        float intensity = (float)(60 - timer) / 60.0f;
        float shakeAmount = intensity * 0.08f;
        return (entity.m_9236_().f_46441_.m_188501_() - 0.5f) * shakeAmount;
    }
}

