/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.client.renderer;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import net.mcreator.redev.entity.PlayerIllusionEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.fml.loading.FMLPaths;

public class PlayerIllusionRenderer
extends HumanoidMobRenderer<PlayerIllusionEntity, HumanoidModel<PlayerIllusionEntity>> {
    private static final MinecraftSessionService sessionService = Minecraft.m_91087_().m_91108_();
    private final TextureManager textureManager = Minecraft.m_91087_().m_91097_();
    private final HumanoidModel<PlayerIllusionEntity> slimModel;
    private final HumanoidModel<PlayerIllusionEntity> defaultModel;

    public PlayerIllusionRenderer(EntityRendererProvider.Context context) {
        super(context, new HumanoidModel(context.m_174023_(ModelLayers.f_171162_)), 0.5f);
        this.slimModel = new HumanoidModel(context.m_174023_(ModelLayers.f_171166_));
        this.defaultModel = new HumanoidModel(context.m_174023_(ModelLayers.f_171162_));
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171165_)), context.m_266367_()));
    }

    public ResourceLocation getTextureLocation(PlayerIllusionEntity entity) {
        if (entity.m_21824_() && entity.m_21805_() != null) {
            UUID ownerUUID = entity.m_21805_();
            return this.getPlayerSkin(ownerUUID);
        }
        return new ResourceLocation("redev:textures/entities/player_illusion_empty.png");
    }

    public void render(PlayerIllusionEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (entity.m_21824_() && entity.m_21805_() != null) {
            UUID ownerUUID = entity.m_21805_();
            this.f_115290_ = this.getModel(ownerUUID);
        }
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private HumanoidModel<PlayerIllusionEntity> getModel(UUID uuid) {
        boolean isSlim = this.isSlimSkin(uuid);
        return isSlim ? this.slimModel : this.defaultModel;
    }

    private ResourceLocation getPlayerSkin(UUID uuid) {
        GameProfile profile = new GameProfile(uuid, null);
        Map textures = sessionService.getTextures(sessionService.fillProfileProperties(profile, false), false);
        if (textures.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            MinecraftProfileTexture profileTexture = (MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN);
            String skinUrl = profileTexture.getUrl();
            String skinHash = profileTexture.getHash();
            ResourceLocation resourceLocation = new ResourceLocation("skins/" + skinHash);
            File skinDir = new File(FMLPaths.GAMEDIR.get().toFile(), "cached_skins");
            File skinFile = new File(skinDir, skinHash + ".png");
            if (!skinDir.exists()) {
                skinDir.mkdirs();
            }
            if (!skinFile.exists()) {
                try {
                    this.downloadSkin(skinUrl, skinFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return DefaultPlayerSkin.m_118627_((UUID)uuid);
                }
            }
            HttpTexture httpTexture = new HttpTexture(skinFile, skinUrl, DefaultPlayerSkin.m_118627_((UUID)uuid), false, null);
            this.textureManager.m_118495_(resourceLocation, (AbstractTexture)httpTexture);
            return resourceLocation;
        }
        return DefaultPlayerSkin.m_118627_((UUID)uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadSkin(String skinUrl, File skinFile) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(skinUrl).openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        try (InputStream inputStream = connection.getInputStream();){
            Files.copy(inputStream, skinFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            connection.disconnect();
        }
    }

    private boolean isSlimSkin(UUID uuid) {
        GameProfile profile = new GameProfile(uuid, null);
        if ((profile = sessionService.fillProfileProperties(profile, false)).getProperties().containsKey((Object)"textures")) {
            for (Property property : profile.getProperties().get((Object)"textures")) {
                String value = new String(Base64.getDecoder().decode(property.getValue()));
                if (!value.contains("\"slim\"")) continue;
                return true;
            }
        }
        return false;
    }
}

