/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AmbushingEnchantment
extends Enchantment {
    public AmbushingEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.WEAPON, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    public boolean m_6591_() {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemstack) {
        return Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("redev:daggers"))).test(itemstack);
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        LivingEntity target = event.getEntity();
        if (target == null) {
            return;
        }
        ItemStack weapon = attacker.m_21205_();
        int level = EnchantmentHelper.m_44843_((Enchantment)this, (ItemStack)weapon);
        if (level > 0) {
            float bonusDamage = AmbushingEnchantment.getBonusDamageForTarget(attacker, target, level);
            event.setAmount(event.getAmount() + bonusDamage);
        }
    }

    public static float getBonusDamageForTarget(LivingEntity attacker, LivingEntity target, int level) {
        if (target.m_21188_() != attacker) {
            return 1.0f + 2.0f * (float)level;
        }
        return 0.0f;
    }
}

