/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.List;
import net.mcreator.redev.init.RedevModEnchantments;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ChaindownEnchantment
extends Enchantment {
    public ChaindownEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.WEAPON, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    protected boolean m_5975_(Enchantment ench) {
        return this != ench && !List.of(Enchantments.f_44980_, Enchantments.f_44981_, Enchantments.f_44962_, (Enchantment)RedevModEnchantments.THUNDERING.get(), (Enchantment)RedevModEnchantments.EXPLODING.get()).contains(ench);
    }

    public boolean m_6591_() {
        return true;
    }

    @SubscribeEvent
    public void onMobHit(LivingHurtEvent event) {
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)source;
        LivingEntity target = event.getEntity();
        if (target == null) {
            return;
        }
        ItemStack weapon = attacker.m_21205_();
        int level = EnchantmentHelper.m_44843_((Enchantment)this, (ItemStack)weapon);
        if (level <= 0) {
            return;
        }
        float chance = 0.1f + 0.2f * (float)level;
        if (target.m_217043_().m_188501_() > chance) {
            return;
        }
        int radius = 1 + level * 2;
        AABB attractionBox = new AABB(target.m_20185_() - (double)radius, target.m_20186_() - (double)radius, target.m_20189_() - (double)radius, target.m_20185_() + (double)radius, target.m_20186_() + (double)radius, target.m_20189_() + (double)radius);
        int maxMobs = 3 + level * 2;
        List nearbyMobs = target.m_9236_().m_6443_(LivingEntity.class, attractionBox, mob -> mob != target && mob != attacker);
        nearbyMobs.sort((mob1, mob2) -> Double.compare(mob1.m_20280_((Entity)target), mob2.m_20280_((Entity)target)));
        int mobsDragged = 0;
        for (LivingEntity mob3 : nearbyMobs) {
            double dz;
            double dy;
            if (mobsDragged >= maxMobs) break;
            double dx = target.m_20185_() - mob3.m_20185_();
            double distance = Math.sqrt(dx * dx + (dy = target.m_20186_() - mob3.m_20186_()) * dy + (dz = target.m_20189_() - mob3.m_20189_()) * dz);
            if (!(distance > 0.0)) continue;
            double strength = 0.1 + 0.2 * (double)level;
            double pullX = dx / distance * strength;
            double pullY = dy / distance * strength;
            double pullZ = dz / distance * strength;
            mob3.m_20256_(mob3.m_20184_().m_82520_(pullX, pullY, pullZ));
            ++mobsDragged;
        }
    }
}

