/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DynamoEnchantment
extends Enchantment {
    public DynamoEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.BOW, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    public boolean m_6591_() {
        return true;
    }

    @SubscribeEvent
    public void onArrowHit(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int level = player.m_21205_().getEnchantmentLevel((Enchantment)this);
        if (level <= 0) {
            return;
        }
        double speed = player.m_20184_().m_82553_();
        double sneakingBowSpeed = 0.05;
        double walkingBowSpeed = 0.1;
        double maxSpeed = 0.5;
        double effectiveSpeed = Math.max(speed - sneakingBowSpeed, 0.0);
        float speedMultiplier = (float)Math.min(effectiveSpeed / (maxSpeed - sneakingBowSpeed), 1.0);
        float maxBonus = 0.15f * (float)level;
        float bonusDamage = event.getAmount() * (speedMultiplier * maxBonus);
        event.setAmount(event.getAmount() + bonusDamage);
    }
}

