/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EchoingEnchantment
extends Enchantment {
    private static final HashMap<UUID, UUID> LAST_TARGET = new HashMap();
    private static final HashMap<UUID, Integer> COMBO_COUNT = new HashMap();
    private static final HashMap<UUID, Integer> RESET_TIMER = new HashMap();
    private static final UUID ATTRIBUTE_UUID = UUID.fromString("81fd06a3-2cf3-4e6d-8d40-f3a93b5bf738");

    public EchoingEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.WEAPON, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    protected boolean m_5975_(Enchantment ench) {
        return this != ench && !List.of(Enchantments.f_44962_, Enchantments.f_44983_).contains(ench);
    }

    @SubscribeEvent
    public void onMobHit(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        LivingEntity target = event.getEntity();
        ItemStack weapon = attacker.m_21205_();
        int level = EnchantmentHelper.m_44843_((Enchantment)this, (ItemStack)weapon);
        if (level <= 0) {
            return;
        }
        UUID attackerUUID = attacker.m_20148_();
        UUID targetUUID = target.m_20148_();
        if (LAST_TARGET.getOrDefault(attackerUUID, null) == targetUUID) {
            int comboCount = COMBO_COUNT.getOrDefault(attackerUUID, 0) + 1;
            COMBO_COUNT.put(attackerUUID, comboCount);
            RESET_TIMER.put(attackerUUID, 60);
            this.applyAttackSpeedModifier(attacker, comboCount, level);
        } else {
            LAST_TARGET.put(attackerUUID, targetUUID);
            COMBO_COUNT.put(attackerUUID, 1);
            RESET_TIMER.put(attackerUUID, 60);
            this.applyAttackSpeedModifier(attacker, 1, level);
        }
    }

    private void applyAttackSpeedModifier(LivingEntity attacker, int comboCount, int level) {
        attacker.m_21204_().m_22146_(Attributes.f_22283_).m_22120_(ATTRIBUTE_UUID);
        double bonus = (0.1 + 0.2 * (double)level) * (double)comboCount;
        AttributeModifier modifier = new AttributeModifier(ATTRIBUTE_UUID, "Echoing Enchantment Bonus", bonus, AttributeModifier.Operation.ADDITION);
        attacker.m_21204_().m_22146_(Attributes.f_22283_).m_22118_(modifier);
    }

    @SubscribeEvent
    public void onEntityTick(TickEvent.PlayerTickEvent event) {
        Player entity = event.player;
        UUID entityUUID = entity.m_20148_();
        if (RESET_TIMER.containsKey(entityUUID)) {
            int timeLeft = RESET_TIMER.get(entityUUID) - 1;
            if (timeLeft <= 0) {
                RESET_TIMER.remove(entityUUID);
                COMBO_COUNT.remove(entityUUID);
                LAST_TARGET.remove(entityUUID);
                entity.m_21204_().m_22146_(Attributes.f_22283_).m_22120_(ATTRIBUTE_UUID);
            } else {
                RESET_TIMER.put(entityUUID, timeLeft);
            }
        }
    }

    public boolean m_6591_() {
        return true;
    }

    public boolean m_6594_() {
        return false;
    }
}

