/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.List;
import java.util.UUID;
import net.mcreator.redev.init.RedevModEnchantments;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FrenzyEnchantment
extends Enchantment {
    private static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("7104e574-b58d-4dc5-b293-b4e1dfe3f354");

    public FrenzyEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.ARMOR_CHEST, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    protected boolean m_5975_(Enchantment ench) {
        return this != ench && !List.of(Enchantments.f_44962_, (Enchantment)RedevModEnchantments.COWARDICE.get()).contains(ench);
    }

    public boolean m_6591_() {
        return true;
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        if (!chestplate.m_41619_() && chestplate.getEnchantmentLevel((Enchantment)this) > 0) {
            double threshold;
            int level = chestplate.getEnchantmentLevel((Enchantment)this);
            double maxHealth = player.m_21233_();
            double currentHealth = player.m_21223_();
            if (currentHealth <= (threshold = maxHealth * (0.5 + 0.1 * (double)level))) {
                double attackSpeedBonus = (threshold - currentHealth) * (0.01 * (double)level);
                this.applyAttackSpeedBoost(player, attackSpeedBonus);
            } else {
                this.removeAttackSpeedBoost(player);
            }
        } else {
            this.removeAttackSpeedBoost(player);
        }
    }

    private void applyAttackSpeedBoost(Player player, double amount) {
        AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22283_);
        if (attributeInstance == null) {
            return;
        }
        attributeInstance.m_22120_(ATTACK_SPEED_MODIFIER);
        attributeInstance.m_22125_(new AttributeModifier(ATTACK_SPEED_MODIFIER, "Frenzy boost", amount, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    private void removeAttackSpeedBoost(Player player) {
        AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22283_);
        if (attributeInstance != null) {
            attributeInstance.m_22120_(ATTACK_SPEED_MODIFIER);
        }
    }

    @SubscribeEvent
    public void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSlot() == EquipmentSlot.CHEST && (event.getTo() == null || event.getTo().m_41619_() || event.getTo().getEnchantmentLevel((Enchantment)this) == 0)) {
                this.removeAttackSpeedBoost(player);
            }
        }
    }
}

