/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HarvestEnchantment
extends Enchantment {
    public HarvestEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.WEAPON, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    protected boolean m_5975_(Enchantment ench) {
        return this != ench && !List.of(Enchantments.f_44987_).contains(ench);
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemstack) {
        return Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("redev:sickles"))).test(itemstack);
    }

    @SubscribeEvent
    public void onMobDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_20193_().m_5776_()) {
            return;
        }
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            ItemStack weapon = attacker.m_21205_();
            int level = weapon.getEnchantmentLevel((Enchantment)this);
            if (level <= 0) {
                return;
            }
            float maxHealth = entity.m_21233_();
            int bonusXP = Math.round(0.25f * (float)level * 8.0f * maxHealth);
            if (bonusXP > 0) {
                ServerLevel world = (ServerLevel)entity.m_20193_();
                world.m_7967_((Entity)new ExperienceOrb((Level)world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), bonusXP));
            }
        }
    }
}

