/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.List;
import net.mcreator.redev.init.RedevModEnchantments;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LeechingEnchantment
extends Enchantment {
    public LeechingEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.WEAPON, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    protected boolean m_5975_(Enchantment ench) {
        return this != ench && !List.of(Enchantments.f_44981_, Enchantments.f_44962_, (Enchantment)RedevModEnchantments.WOUNDING.get()).contains(ench);
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemstack) {
        return Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("redev:daggers"))).test(itemstack);
    }

    public boolean m_6591_() {
        return true;
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        ItemStack weapon = attacker.m_21205_();
        int level = weapon.getEnchantmentLevel((Enchantment)this);
        if (level <= 0) {
            return;
        }
        float damageDealt = event.getAmount();
        float healingAmount = damageDealt * (0.1f + 0.2f * (float)level);
        if (healingAmount > 0.0f && attacker instanceof Player) {
            Player player = (Player)attacker;
            player.m_5634_(healingAmount);
            this.spawnHeartParticles((LivingEntity)player, player.m_9236_(), level);
        }
    }

    private void spawnHeartParticles(LivingEntity entity, Level level, int enchantmentLevel) {
        int particleCount = switch (enchantmentLevel) {
            case 1 -> 3;
            case 2 -> 5;
            case 3 -> 7;
            default -> 0;
        };
        double minX = entity.m_20191_().f_82288_;
        double minY = entity.m_20191_().f_82289_;
        double minZ = entity.m_20191_().f_82290_;
        double maxX = entity.m_20191_().f_82291_;
        double maxY = entity.m_20191_().f_82292_;
        double maxZ = entity.m_20191_().f_82293_;
        for (int i = 0; i < particleCount; ++i) {
            double x = minX + (maxX - minX) * level.f_46441_.m_188500_();
            double y = minY + (maxY - minY) * level.f_46441_.m_188500_();
            double z = minZ + (maxZ - minZ) * level.f_46441_.m_188500_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123750_, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

