/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MagnetizeEnchantment
extends Enchantment {
    public MagnetizeEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.ARMOR_CHEST, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    public boolean m_6591_() {
        return true;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!player.m_6047_()) {
            return;
        }
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        if (chestplate.m_41619_()) {
            return;
        }
        int level = EnchantmentHelper.m_44843_((Enchantment)this, (ItemStack)chestplate);
        if (level <= 0) {
            return;
        }
        int radius = 3 + level;
        AABB attractionBox = new AABB(player.m_20185_() - (double)radius, player.m_20186_() - (double)radius, player.m_20189_() - (double)radius, player.m_20185_() + (double)radius, player.m_20186_() + (double)radius, player.m_20189_() + (double)radius);
        List nearbyItems = player.m_9236_().m_45976_(ItemEntity.class, attractionBox);
        for (ItemEntity item : nearbyItems) {
            double dz;
            double dy;
            double dx = player.m_20185_() - item.m_20185_();
            double distance = Math.sqrt(dx * dx + (dy = player.m_20186_() + 0.5 - item.m_20186_()) * dy + (dz = player.m_20189_() - item.m_20189_()) * dz);
            if (!(distance > 0.0)) continue;
            double strength = 0.05 + 0.01 * (double)level;
            double pullX = dx / distance * strength;
            double pullY = dy / distance * strength;
            double pullZ = dz / distance * strength;
            item.m_20256_(item.m_20184_().m_82520_(pullX, pullY, pullZ));
        }
    }
}

