/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.enchantment;

import java.util.List;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class StoneStanceEnchantment
extends Enchantment {
    private static final UUID KNOCKBACK_RESISTANCE_MODIFIER = UUID.fromString("e3b22e0d-9338-4f8a-ae8b-27e7a5b90c53");

    public StoneStanceEnchantment(EquipmentSlot ... slots) {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.ARMOR_LEGS, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int m_6586_() {
        return 3;
    }

    protected boolean m_5975_(Enchantment ench) {
        return this != ench && !List.of(Enchantments.f_44972_).contains(ench);
    }

    public boolean m_6591_() {
        return true;
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack leggings = player.m_6844_(EquipmentSlot.LEGS);
        if (!leggings.m_41619_() && leggings.getEnchantmentLevel((Enchantment)this) > 0) {
            int level = leggings.getEnchantmentLevel((Enchantment)this);
            double resistanceBonus = 0.15 * (double)level;
            this.applyKnockbackResistance(player, resistanceBonus);
        } else {
            this.removeKnockbackResistance(player);
        }
    }

    private void applyKnockbackResistance(Player player, double amount) {
        AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22278_);
        if (attributeInstance == null) {
            return;
        }
        attributeInstance.m_22120_(KNOCKBACK_RESISTANCE_MODIFIER);
        attributeInstance.m_22125_(new AttributeModifier(KNOCKBACK_RESISTANCE_MODIFIER, "Stone Stance bonus", amount, AttributeModifier.Operation.ADDITION));
    }

    private void removeKnockbackResistance(Player player) {
        AttributeInstance attributeInstance = player.m_21051_(Attributes.f_22278_);
        if (attributeInstance != null) {
            attributeInstance.m_22120_(KNOCKBACK_RESISTANCE_MODIFIER);
        }
    }

    @SubscribeEvent
    public void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSlot() == EquipmentSlot.LEGS && (event.getTo() == null || event.getTo().m_41619_() || event.getTo().getEnchantmentLevel((Enchantment)this) == 0)) {
                this.removeKnockbackResistance(player);
            }
        }
    }
}

