/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import net.mcreator.redev.entity.AmethystShardProjectileEntity;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class AmethystArrowProjectileEntity
extends AbstractArrow {
    private static final double dmg = 3.0;

    public AmethystArrowProjectileEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType<? extends AmethystArrowProjectileEntity>)((EntityType)RedevModEntities.AMETHYST_ARROW_PROJECTILE.get()), world);
    }

    public AmethystArrowProjectileEntity(EntityType<? extends AmethystArrowProjectileEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_36781_(3.0);
    }

    public AmethystArrowProjectileEntity(Level worldIn, double x, double y, double z) {
        super((EntityType)RedevModEntities.AMETHYST_ARROW_PROJECTILE.get(), x, y, z, worldIn);
        this.m_36781_(3.0);
    }

    public AmethystArrowProjectileEntity(Level worldIn, LivingEntity shooter) {
        super((EntityType)RedevModEntities.AMETHYST_ARROW_PROJECTILE.get(), shooter, worldIn);
        this.m_36781_(3.0);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_42412_);
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)entity;
            ItemStack heldItem = shooter.m_21211_();
            if (heldItem.m_41720_() instanceof BowItem) {
                if (shooter.m_21252_() >= 20) {
                    this.spawnExtraArrows(x, y, z, velocity, inaccuracy, shooter);
                }
            } else if (heldItem.m_41720_() instanceof CrossbowItem && CrossbowItem.m_40932_((ItemStack)heldItem)) {
                this.spawnExtraArrows(x, y, z, velocity, inaccuracy, shooter);
            }
        }
    }

    private void spawnExtraArrows(double x, double y, double z, float velocity, float inaccuracy, LivingEntity shooter) {
        int extraShards = this.m_9236_().f_46441_.m_188503_(3) + 2;
        for (int i = 0; i < extraShards; ++i) {
            AmethystShardProjectileEntity shard = new AmethystShardProjectileEntity(this.m_9236_(), shooter);
            shard.m_36781_(1.0);
            double offsetX = this.m_9236_().f_46441_.m_188583_() * 0.075;
            double offsetZ = this.m_9236_().f_46441_.m_188583_() * 0.075;
            shard.m_6686_(x + offsetX, y, z + offsetZ, velocity, inaccuracy * 0.8f);
            this.m_9236_().m_7967_((Entity)shard);
        }
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        if (entityHitResult.m_82443_() != null) {
            entityHitResult.m_82443_().m_6469_(this.createAmethystBleedDamageSource(), (float)this.m_36789_());
        }
    }

    private DamageSource createAmethystBleedDamageSource() {
        Holder.Reference damageType = this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("redev:amethyst_bleed")));
        return new DamageSource((Holder)damageType);
    }
}

