/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class BadgerEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Integer> DIGGING_TIMER = SynchedEntityData.m_135353_(BadgerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SLIMEBALL_COOLDOWN = SynchedEntityData.m_135353_(BadgerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BadgerEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<BadgerEntity>)((EntityType)RedevModEntities.BADGER.get()), world);
    }

    public BadgerEntity(EntityType<BadgerEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 0;
        this.m_21557_(false);
        if (!world.f_46443_) {
            this.resetDiggingTimer();
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new FollowMobGoal((Mob)this, 1.0, 10.0f, 5.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false, false));
        this.f_21345_.m_25352_(6, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(7, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42784_}), false));
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (target instanceof TamableAnimal) {
            TamableAnimal tamed = (TamableAnimal)target;
            return !tamed.m_21824_() || tamed.m_269323_() != owner;
        }
        if (target instanceof Player && owner instanceof Player) {
            return ((Player)owner).m_7099_((Player)target);
        }
        return true;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.m_19983_(new ItemStack((ItemLike)Items.f_42454_));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DIGGING_TIMER, (Object)this.getRandomDiggingTime());
        this.f_19804_.m_135372_(SLIMEBALL_COOLDOWN, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("DiggingTimer", ((Integer)this.f_19804_.m_135370_(DIGGING_TIMER)).intValue());
        tag.m_128405_("SlimeballCooldown", ((Integer)this.f_19804_.m_135370_(SLIMEBALL_COOLDOWN)).intValue());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("DiggingTimer")) {
            this.f_19804_.m_135381_(DIGGING_TIMER, (Object)tag.m_128451_("DiggingTimer"));
        }
        if (tag.m_128441_("SlimeballCooldown")) {
            this.f_19804_.m_135381_(SLIMEBALL_COOLDOWN, (Object)tag.m_128451_("SlimeballCooldown"));
        }
    }

    private int getRandomDiggingTime() {
        return 6000 + this.f_19796_.m_188503_(3600);
    }

    private void resetDiggingTimer() {
        this.f_19804_.m_135381_(DIGGING_TIMER, (Object)this.getRandomDiggingTime());
    }

    private void resetSlimeballCooldown() {
        this.f_19804_.m_135381_(SLIMEBALL_COOLDOWN, (Object)6000);
    }

    private void startDigging() {
        ServerLevel world = (ServerLevel)this.m_9236_();
        BlockPos pos = this.m_20183_();
        BlockState blockUnder = world.m_8055_(pos.m_7495_());
        for (int i = 0; i < 20; ++i) {
            double offsetX = (world.f_46441_.m_188500_() - 0.5) * 0.5;
            double offsetZ = (world.f_46441_.m_188500_() - 0.5) * 0.5;
            world.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockUnder), (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5 + offsetZ, 5, 0.0, 0.1, 0.0, 0.1);
        }
        ResourceLocation lootTable = new ResourceLocation("redev", "entities/badger_digging");
        LootParams lootParams = new LootParams.Builder(world).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81461_, (Object)blockUnder).m_287286_(LootContextParams.f_81457_, (Object)world.m_269111_().m_269264_()).m_287235_(LootContextParamSets.f_81415_);
        LootTable table = world.m_7654_().m_278653_().m_278676_(lootTable);
        ObjectArrayList loot = table.m_287195_(lootParams);
        for (ItemStack item : loot) {
            this.m_19983_(item);
        }
    }

    private BlockPos findNearbyDirtBlock() {
        BlockPos currentPos = this.m_20183_();
        for (int x = -5; x <= 5; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    BlockPos checkPos = currentPos.m_7918_(x, y, z);
                    if (!this.m_9236_().m_8055_(checkPos).m_204336_(BlockTags.f_144274_) || !this.m_9236_().m_46859_(checkPos.m_7494_())) continue;
                    return checkPos;
                }
            }
        }
        return null;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:badger.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:badger.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:badger.death"));
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            int diggingTime = (Integer)this.f_19804_.m_135370_(DIGGING_TIMER);
            int slimeCooldown = (Integer)this.f_19804_.m_135370_(SLIMEBALL_COOLDOWN);
            if (diggingTime > 0) {
                this.f_19804_.m_135381_(DIGGING_TIMER, (Object)(diggingTime - 1));
            } else if (this.m_20096_() && this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_204336_(BlockTags.f_144274_)) {
                this.startDigging();
                this.resetDiggingTimer();
            }
            if (slimeCooldown > 0) {
                this.f_19804_.m_135381_(SLIMEBALL_COOLDOWN, (Object)(slimeCooldown - 1));
            }
        }
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof SpawnEggItem) {
            return super.m_6071_(sourceentity, hand);
        }
        if (this.m_9236_().m_5776_()) {
            return this.m_21824_() && this.m_21830_((LivingEntity)sourceentity) || this.m_6898_(itemstack) ? InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()) : InteractionResult.PASS;
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)sourceentity)) {
            if (item.m_41472_() && this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                this.m_142075_(sourceentity, hand, itemstack);
                this.m_5634_(item.m_41473_().m_38744_());
                return InteractionResult.SUCCESS;
            }
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                this.m_142075_(sourceentity, hand, itemstack);
                this.m_5634_(4.0f);
                return InteractionResult.SUCCESS;
            }
        } else {
            if (this.m_6898_(itemstack)) {
                this.m_142075_(sourceentity, hand, itemstack);
                if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)sourceentity)) {
                    this.m_21828_(sourceentity);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
                this.m_21530_();
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_150930_(Items.f_42518_)) {
                if ((Integer)this.f_19804_.m_135370_(SLIMEBALL_COOLDOWN) > 0) {
                    return InteractionResult.FAIL;
                }
                BlockPos dirtPos = this.findNearbyDirtBlock();
                if (dirtPos != null) {
                    this.m_21573_().m_26519_((double)dirtPos.m_123341_(), (double)dirtPos.m_123342_(), (double)dirtPos.m_123343_(), 1.0);
                    this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11949_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    this.f_19804_.m_135381_(DIGGING_TIMER, (Object)this.getRandomDiggingTime());
                    this.startDigging();
                    this.f_19804_.m_135381_(SLIMEBALL_COOLDOWN, (Object)3600);
                    itemstack.m_41774_(1);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6071_(sourceentity, hand);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        BadgerEntity retval = (BadgerEntity)((EntityType)RedevModEntities.BADGER.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42784_)}).test(stack);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)RedevModEntities.BADGER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_) && world.m_45524_(pos, 0) > 8);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 10.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }
}

