/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import java.util.List;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class BarnacleEntity
extends Squid {
    private boolean isPulling = false;
    private long pullCooldownTime = 0L;
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(BarnacleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BarnacleEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<BarnacleEntity>)((EntityType)RedevModEntities.BARNACLE.get()), world);
    }

    public BarnacleEntity(EntityType<BarnacleEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 7;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        int rand = this.f_19796_.m_188503_(100);
        if (rand < 60) {
            this.setVariant(0);
        } else if (rand < 90) {
            this.setVariant(1);
        } else {
            this.setVariant(2);
        }
        this.m_6210_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_5842_()) {
            this.isPulling = false;
            return;
        }
        if (System.currentTimeMillis() >= this.pullCooldownTime) {
            this.isPulling = true;
        }
        if (this.isPulling) {
            boolean isAnyTargetInRange = false;
            List targets = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(4.0));
            for (LivingEntity target : targets) {
                if (target == this || !(this.m_20280_((Entity)target) <= 36.0) || !this.isTarget(target)) continue;
                this.pullTarget(target);
                if (!(this.m_20280_((Entity)target) <= 2.25)) continue;
                this.applyDrowningDamage(target);
                isAnyTargetInRange = true;
            }
            List boats = this.m_9236_().m_45976_(Boat.class, this.m_20191_().m_82386_(-2.5, 0.0, -2.5).m_82377_(2.5, 8.0, 2.5));
            for (Boat boat : boats) {
                if (this.m_20280_((Entity)boat) <= 2.25) {
                    this.breakBoat(boat);
                    continue;
                }
                this.pullBoat(boat);
            }
            if (isAnyTargetInRange) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.125, 0.0));
            }
        }
    }

    public boolean isAnyTargetInRange() {
        List targets = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(1.5));
        for (LivingEntity target : targets) {
            if (target == this || !(this.m_20280_((Entity)target) <= 2.25)) continue;
            return true;
        }
        return false;
    }

    private void breakBoat(Boat boat) {
        if (!boat.m_213877_()) {
            boat.m_6074_();
            boat.m_19998_((ItemLike)boat.m_38369_());
        }
    }

    private boolean isTarget(LivingEntity entity) {
        return (!(entity instanceof Player) || !((Player)entity).m_7500_()) && !(entity instanceof BarnacleEntity);
    }

    private void pullTarget(LivingEntity target) {
        double dz;
        double dy;
        double dx = this.m_20185_() - target.m_20185_();
        double distance = Math.sqrt(dx * dx + (dy = this.m_20186_() + 0.75 - target.m_20186_()) * dy + (dz = this.m_20189_() - target.m_20189_()) * dz);
        if (distance > 0.5) {
            double pullStrength = 0.15;
            target.m_20256_(target.m_20184_().m_82520_(dx / distance * pullStrength, dy / distance * pullStrength, dz / distance * pullStrength));
        }
    }

    private void pullBoat(Boat boat) {
        double dz;
        double dy;
        double dx = this.m_20185_() - boat.m_20185_();
        double distance = Math.sqrt(dx * dx + (dy = this.m_20186_() - boat.m_20186_()) * dy + (dz = this.m_20189_() - boat.m_20189_()) * dz);
        if (distance > 0.5) {
            double pullStrength = 0.15;
            boat.m_20256_(boat.m_20184_().m_82520_(dx / distance * pullStrength, dy / distance * pullStrength, dz / distance * pullStrength));
        }
    }

    private void applyDrowningDamage(LivingEntity target) {
        DamageSource drownDamage = this.m_9236_().m_269111_().m_269063_();
        target.m_6469_(drownDamage, 2.0f);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isPulling && this.f_19796_.m_188501_() < 0.15f) {
            this.isPulling = false;
            this.pullCooldownTime = System.currentTimeMillis() + 3000L;
        }
        return super.m_6469_(source, amount);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:barnacle.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:barnacle.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:barnacle.death"));
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(1.5f);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", ((Integer)this.f_19804_.m_135370_(VARIANT)).intValue());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Variant")) {
            this.f_19804_.m_135381_(VARIANT, (Object)compound.m_128451_("Variant"));
        }
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)RedevModEntities.BARNACLE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_8055_(pos).m_60713_(Blocks.f_49990_) && world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_));
    }

    public static AttributeSupplier.Builder m_29988_() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 1.0);
        builder = builder.m_22268_(Attributes.f_22276_, 30.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 4.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0);
        return builder;
    }
}

