/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import java.util.Collection;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class ConjuredSlimeEntity
extends Slime {
    private boolean diedByHit = false;

    public ConjuredSlimeEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<ConjuredSlimeEntity>)((EntityType)RedevModEntities.CONJURED_SLIME.get()), world);
    }

    public ConjuredSlimeEntity(EntityType<ConjuredSlimeEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 1;
        this.m_21557_(false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (!this.m_9236_().f_46443_ && !this.diedByHit) {
            this.createPotionCloud();
        }
    }

    private void createPotionCloud() {
        Collection effects = this.m_21220_();
        if (effects.isEmpty()) {
            return;
        }
        AreaEffectCloud cloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        cloud.m_19712_(2.0f);
        cloud.m_19734_(20);
        cloud.m_19740_(0);
        cloud.m_19718_((LivingEntity)this);
        for (MobEffectInstance effect : effects) {
            cloud.m_19716_(new MobEffectInstance(effect));
        }
        this.m_9236_().m_7967_((Entity)cloud);
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 30, 0.5, 0.5, 0.5, 0.1);
    }

    public boolean m_7327_(Entity target) {
        boolean success = super.m_7327_(target);
        if (success && target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            for (MobEffectInstance effect : this.m_21220_()) {
                living.m_7292_(new MobEffectInstance(effect));
            }
            this.diedByHit = true;
            if (!this.m_9236_().f_46443_) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 20, 0.3, 0.3, 0.3, 0.05);
            }
            this.m_6469_(this.m_269291_().m_269264_(), Float.MAX_VALUE);
        }
        return success;
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.15);
        builder = builder.m_22268_(Attributes.f_22276_, 1.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }
}

