/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import java.util.EnumSet;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class GlareEntity
extends TamableAnimal
implements FlyingAnimal {
    private static final EntityDataAccessor<Integer> GROWTH_TIMER = SynchedEntityData.m_135353_(GlareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> GLARE_BERRIES = SynchedEntityData.m_135353_(GlareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> GROWTH_FROZEN = SynchedEntityData.m_135353_(GlareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public GlareEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<GlareEntity>)((EntityType)RedevModEntities.GLARE.get()), world);
    }

    public GlareEntity(EntityType<GlareEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 1;
        this.m_21557_(false);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
        this.f_19804_.m_135372_(GROWTH_TIMER, (Object)6000);
        this.f_19804_.m_135372_(GLARE_BERRIES, (Object)false);
        this.f_19804_.m_135372_(GROWTH_FROZEN, (Object)false);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("GrowthTimer", ((Integer)this.f_19804_.m_135370_(GROWTH_TIMER)).intValue());
        tag.m_128379_("GlareBerries", ((Boolean)this.f_19804_.m_135370_(GLARE_BERRIES)).booleanValue());
        tag.m_128379_("GrowthFrozen", ((Boolean)this.f_19804_.m_135370_(GROWTH_FROZEN)).booleanValue());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("GrowthTimer")) {
            this.f_19804_.m_135381_(GROWTH_TIMER, (Object)tag.m_128451_("GrowthTimer"));
        }
        if (tag.m_128441_("GlareBerries")) {
            this.f_19804_.m_135381_(GLARE_BERRIES, (Object)tag.m_128471_("GlareBerries"));
        }
        if (tag.m_128441_("GrowthFrozen")) {
            this.f_19804_.m_135381_(GROWTH_FROZEN, (Object)tag.m_128471_("GrowthFrozen"));
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected PathNavigation m_6037_(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, Monster.class, 8.0f, 1.2, 1.5));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new MoveToDarkSpotGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.5f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 5.0f, 3.0f));
        this.f_21345_.m_25352_(9, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(10, (Goal)new BreedGoal((Animal)this, 1.3));
        this.f_21345_.m_25352_(11, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42499_}), false));
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.m_19983_(new ItemStack((ItemLike)Blocks.f_152544_));
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.enderman.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.silverfish.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.silverfish.death"));
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        return false;
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        InteractionResult result;
        ItemStack itemstack = sourceentity.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.m_9236_().f_46443_) {
            return this.m_21824_() && this.m_21830_((LivingEntity)sourceentity) || this.m_6898_(itemstack) || (Boolean)this.f_19804_.m_135370_(GLARE_BERRIES) != false ? InteractionResult.m_19078_((boolean)true) : InteractionResult.PASS;
        }
        if (((Boolean)this.f_19804_.m_135370_(GLARE_BERRIES)).booleanValue()) {
            this.f_19804_.m_135381_(GLARE_BERRIES, (Object)false);
            this.f_19804_.m_135381_(GROWTH_TIMER, (Object)6000);
            sourceentity.m_36324_().m_38707_(4, 1.2f);
            return InteractionResult.SUCCESS;
        }
        if (this.m_6898_(itemstack)) {
            if (((Boolean)this.f_19804_.m_135370_(GROWTH_FROZEN)).booleanValue()) {
                this.f_19804_.m_135381_(GROWTH_FROZEN, (Object)false);
            } else {
                this.f_19804_.m_135381_(GROWTH_TIMER, (Object)0);
                this.f_19804_.m_135381_(GLARE_BERRIES, (Object)true);
            }
            itemstack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        if (item == Items.f_42574_) {
            boolean frozen = (Boolean)this.f_19804_.m_135370_(GROWTH_FROZEN) == false;
            this.f_19804_.m_135381_(GROWTH_FROZEN, (Object)frozen);
            this.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)sourceentity)) {
                if (item.m_41472_() && this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(item.m_41473_().m_38744_());
                    return InteractionResult.SUCCESS;
                }
                if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(4.0f);
                    return InteractionResult.SUCCESS;
                }
            }
        } else if (this.m_6898_(itemstack)) {
            this.m_142075_(sourceentity, hand, itemstack);
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.m_21828_(sourceentity);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            this.m_21530_();
            return InteractionResult.SUCCESS;
        }
        if ((result = super.m_6071_(sourceentity, hand)) == InteractionResult.SUCCESS || result == InteractionResult.CONSUME) {
            this.m_21530_();
        }
        return result;
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        GlareEntity retval = (GlareEntity)((EntityType)RedevModEntities.GLARE.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42499_)}).test(stack);
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_20242_(true);
        if (!this.m_9236_().f_46443_ && !((Boolean)this.f_19804_.m_135370_(GROWTH_FROZEN)).booleanValue()) {
            int timer = (Integer)this.f_19804_.m_135370_(GROWTH_TIMER);
            if (timer > 0) {
                this.f_19804_.m_135381_(GROWTH_TIMER, (Object)(timer - (this.m_9236_().m_45527_(this.m_20183_()) ? 2 : 1)));
            } else {
                this.f_19804_.m_135381_(GLARE_BERRIES, (Object)true);
            }
        }
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)RedevModEntities.GLARE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> pos.m_123342_() <= 50 && !world.m_45527_(pos));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 10.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22280_, 0.25);
        return builder;
    }

    private class MoveToDarkSpotGoal
    extends Goal {
        private final GlareEntity glare;
        private int cooldown;

        public MoveToDarkSpotGoal(GlareEntity glare) {
            this.glare = glare;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            BlockPos targetPos = this.findDarkSpot();
            if (targetPos != null) {
                this.glare.m_21573_().m_26519_((double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_(), 1.2);
                this.cooldown = 100 + this.glare.m_217043_().m_188503_(100);
                return true;
            }
            return false;
        }

        public void m_8056_() {
            this.cooldown = 100 + this.glare.m_217043_().m_188503_(100);
        }

        private BlockPos findDarkSpot() {
            BlockPos currentPos = this.glare.m_20183_();
            for (int x = -8; x <= 8; ++x) {
                for (int y = -3; y <= 3; ++y) {
                    for (int z = -8; z <= 8; ++z) {
                        BlockPos checkPos = currentPos.m_7918_(x, y, z);
                        if (this.glare.m_9236_().m_46803_(checkPos) >= 5 || !this.glare.m_9236_().m_46859_(checkPos)) continue;
                        return checkPos;
                    }
                }
            }
            return null;
        }
    }
}

