/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class GlimEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Boolean> LIT = SynchedEntityData.m_135353_(GlimEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int litTicks = 0;

    public GlimEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<GlimEntity>)((EntityType)RedevModEntities.GLIM.get()), world);
    }

    public GlimEntity(EntityType<GlimEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, false));
        this.f_21346_.m_25352_(5, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(6, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(7, (Goal)new FollowMobGoal((Mob)this, 1.0, 10.0f, 10.0f));
        this.f_21346_.m_25352_(8, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true));
        this.f_21346_.m_25352_(9, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (target instanceof Monster) {
            return true;
        }
        if (target instanceof TamableAnimal) {
            TamableAnimal tamed = (TamableAnimal)target;
            return !tamed.m_21824_() || tamed.m_269323_() != owner;
        }
        if (target instanceof Player && owner instanceof Player) {
            return ((Player)owner).m_7099_((Player)target);
        }
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LIT, (Object)false);
    }

    public boolean isLit() {
        return (Boolean)this.f_19804_.m_135370_(LIT);
    }

    public void setLit(boolean lit, int durationTicks) {
        this.f_19804_.m_135381_(LIT, (Object)lit);
        this.litTicks = durationTicks;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("lit", this.isLit());
        tag.m_128405_("litTicks", this.litTicks);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setLit(tag.m_128471_("lit"), tag.m_128451_("litTicks"));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_20077_() || this.m_6060_()) {
            this.setLit(true, 2400);
        }
        if (this.m_20070_()) {
            this.setLit(false, 0);
        }
        if (this.isLit()) {
            if (this.litTicks > 0) {
                --this.litTicks;
            } else {
                this.setLit(false, 0);
            }
            if (this.m_9236_().f_46443_) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + 0.9375, this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean m_7327_(Entity target) {
        boolean success = super.m_7327_(target);
        if (success && this.isLit() && target instanceof LivingEntity) {
            target.m_20254_(3);
        }
        return success;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.spider.ambient"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.candle.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.spider.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.candle.extinguish"));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean m_5825_() {
        return true;
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        Item item = itemstack.m_41720_();
        if (this.m_6898_(itemstack)) {
            if (this.m_21824_() && this.m_21830_((LivingEntity)sourceentity)) {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(4.0f);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
            } else if (!this.m_21824_()) {
                this.m_142075_(sourceentity, hand, itemstack);
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_21828_(sourceentity);
                    this.m_21530_();
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
        }
        if (item == Items.f_42409_ || item == Items.f_42613_) {
            int duration = item == Items.f_42409_ ? 600 : 1200;
            this.setLit(true, duration);
            this.m_5496_(SoundEvents.f_11874_, 1.0f, 1.0f);
            if (!sourceentity.m_150110_().f_35937_) {
                if (item == Items.f_42613_) {
                    itemstack.m_41774_(1);
                } else {
                    itemstack.m_41622_(1, (LivingEntity)sourceentity, p -> p.m_21190_(hand));
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(sourceentity, hand);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        GlimEntity retval = (GlimEntity)((EntityType)RedevModEntities.GLIM.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42784_)}).test(stack);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.27);
        builder = builder.m_22268_(Attributes.f_22276_, 6.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.1);
        return builder;
    }
}

