/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import java.util.EnumSet;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class GrindstoneGolemEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(GrindstoneGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public GrindstoneGolemEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<GrindstoneGolemEntity>)((EntityType)RedevModEntities.GRINDSTONE_GOLEM.get()), world);
    }

    public GrindstoneGolemEntity(EntityType<GrindstoneGolemEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.2f);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new ChargeAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(7, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(8, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false, false));
        this.f_21346_.m_25352_(9, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (target instanceof Monster) {
            return true;
        }
        if (target instanceof TamableAnimal) {
            TamableAnimal tamed = (TamableAnimal)target;
            return !tamed.m_21824_() || tamed.m_269323_() != owner;
        }
        if (target instanceof Player && owner instanceof Player) {
            return ((Player)owner).m_7099_((Player)target);
        }
        return true;
    }

    public void m_7334_(Entity target) {
        if (this.getAttackState() == 2) {
            TamableAnimal tamable;
            if (target instanceof TamableAnimal && (tamable = (TamableAnimal)target).m_269323_() == this.m_269323_()) {
                return;
            }
            if (target instanceof Player && target == this.m_269323_()) {
                return;
            }
            target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 5.0f);
            target.m_20256_(target.m_20184_().m_82520_(0.0, 0.3, 0.0));
        }
        super.m_7334_(target);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
    }

    public int getAttackState() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_STATE);
    }

    public void setAttackState(int state) {
        this.f_19804_.m_135381_(ATTACK_STATE, (Object)state);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getAttackState() == 2) {
            this.spawnSprintParticles();
        }
    }

    private void spawnSprintParticles() {
        if (this.m_9236_().f_46443_) {
            BlockPos blockPos = this.m_20183_().m_7495_();
            BlockState blockState = this.m_9236_().m_8055_(blockPos);
            if (!blockState.m_60795_()) {
                for (int i = 0; i < 5; ++i) {
                    double xOffset = (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
                    double zOffset = (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), this.m_20185_() + xOffset, this.m_20186_(), this.m_20189_() + zOffset, 0.0, 0.1, 0.0);
                }
            }
        }
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.grindstone.use"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.grindstone.use")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.polished_deepslate.hit"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.polished_deepslate.break"));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        Item item = itemstack.m_41720_();
        if (this.m_6898_(itemstack)) {
            if (this.m_21824_() && this.m_21830_((LivingEntity)sourceentity)) {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(4.0f);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
            } else if (!this.m_21824_()) {
                this.m_142075_(sourceentity, hand, itemstack);
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_21828_(sourceentity);
                    this.m_21530_();
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
        }
        return super.m_6071_(sourceentity, hand);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        return null;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42192_);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.275);
        builder = builder.m_22268_(Attributes.f_22276_, 12.0);
        builder = builder.m_22268_(Attributes.f_22284_, 1.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.3);
        builder = builder.m_22268_(Attributes.f_22278_, 0.1);
        return builder;
    }

    public class ChargeAttackGoal
    extends Goal {
        private final GrindstoneGolemEntity golem;
        private LivingEntity target;
        private int chargeTime;
        private int cooldownTime;
        private Vec3 chargeDirection;

        public ChargeAttackGoal(GrindstoneGolemEntity golem) {
            this.golem = golem;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.golem.getAttackState() != 0 || this.golem.m_5448_() == null) {
                return false;
            }
            this.target = this.golem.m_5448_();
            return (double)this.golem.m_20270_((Entity)this.target) > 4.0;
        }

        public void m_8056_() {
            this.chargeTime = 15;
            this.cooldownTime = 0;
            this.golem.setAttackState(1);
            this.golem.m_21573_().m_26573_();
            this.golem.m_21391_((Entity)this.target, 30.0f, 30.0f);
            Vec3 toTarget = this.target.m_20182_().m_82546_(this.golem.m_20182_()).m_82541_();
            this.chargeDirection = new Vec3(toTarget.f_82479_, 0.0, toTarget.f_82481_);
        }

        public void m_8037_() {
            if (this.chargeTime > 0) {
                --this.chargeTime;
                this.golem.m_21391_((Entity)this.target, 30.0f, 30.0f);
            } else if (this.chargeTime == 0) {
                this.golem.setAttackState(2);
                Vec3 currentMotion = this.golem.m_20184_();
                this.golem.m_20256_(this.chargeDirection.m_82490_(1.05).m_82520_(0.0, currentMotion.f_82480_, 0.0));
                this.chargeTime = -1;
            } else if (this.chargeTime == -1) {
                if (this.cooldownTime < 4) {
                    ++this.cooldownTime;
                    Vec3 currentMotion = this.golem.m_20184_();
                    this.golem.m_20256_(this.chargeDirection.m_82490_(1.05).m_82520_(0.0, currentMotion.f_82480_, 0.0));
                } else {
                    this.golem.setAttackState(0);
                    this.chargeTime = 0;
                }
            }
        }

        public void m_8041_() {
            this.golem.setAttackState(0);
        }

        public boolean m_8045_() {
            return this.chargeTime != 0 || this.cooldownTime < 4;
        }
    }
}

