/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class PlankGolemEntity
extends TamableAnimal
implements RangedAttackMob {
    private ItemStack currentProjectileStack = new ItemStack((ItemLike)Items.f_42412_);

    public PlankGolemEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<PlankGolemEntity>)((EntityType)RedevModEntities.PLANK_GOLEM.get()), world);
    }

    public PlankGolemEntity(EntityType<PlankGolemEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal(this, 1.25, 15, 6.0f){

            public boolean m_8045_() {
                return this.m_8036_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(6, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(7, (Goal)new FollowMobGoal((Mob)this, 1.0, 10.0f, 10.0f));
        this.f_21346_.m_25352_(8, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false, false));
        this.f_21346_.m_25352_(9, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (target instanceof Monster) {
            return true;
        }
        if (target instanceof TamableAnimal) {
            TamableAnimal tamed = (TamableAnimal)target;
            return !tamed.m_21824_() || tamed.m_269323_() != owner;
        }
        if (target instanceof Player && owner instanceof Player) {
            return ((Player)owner).m_7099_((Player)target);
        }
        return true;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:plank_golem.idle"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:plank_golem.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:plank_golem.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:plank_golem.death"));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        boolean isProjectile;
        ItemStack itemstack = sourceentity.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item == Items.f_42398_) {
            if (this.m_21824_() && this.m_21830_((LivingEntity)sourceentity)) {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(2.0f);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
            } else if (!this.m_21824_()) {
                this.m_142075_(sourceentity, hand, itemstack);
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_21828_(sourceentity);
                    this.m_21530_();
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
        }
        boolean bl = isProjectile = item == Items.f_42412_ || item == Items.f_42737_ || item == Items.f_42452_ || item == Items.f_42521_;
        if (isProjectile) {
            if (!ItemStack.m_150942_((ItemStack)this.currentProjectileStack, (ItemStack)itemstack)) {
                this.currentProjectileStack = itemstack.m_41777_();
                if (!sourceentity.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_9236_().m_7605_((Entity)this, (byte)7);
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            return InteractionResult.PASS;
        }
        return super.m_6071_(sourceentity, hand);
    }

    public void m_6504_(LivingEntity target, float flval) {
        Snowball projectile;
        if (this.currentProjectileStack.m_150930_(Items.f_42452_)) {
            projectile = new Snowball(this.m_9236_(), (LivingEntity)this);
        } else if (this.currentProjectileStack.m_150930_(Items.f_42521_)) {
            projectile = new ThrownEgg(this.m_9236_(), (LivingEntity)this);
        } else if (this.currentProjectileStack.m_150930_(Items.f_42737_)) {
            projectile = new SpectralArrow(this.m_9236_(), (LivingEntity)this);
        } else {
            Arrow arrow = new Arrow(this.m_9236_(), (LivingEntity)this);
            if (!this.m_21220_().isEmpty()) {
                for (MobEffectInstance effect : this.m_21220_()) {
                    arrow.m_36870_(new MobEffectInstance(effect));
                }
            }
            projectile = arrow;
        }
        projectile.m_5602_((Entity)this);
        PlankGolemEntity.shootProjectile(this, (Entity)projectile, target);
    }

    private static void shootProjectile(PlankGolemEntity shooter, Entity projectile, LivingEntity target) {
        double targetX = target.m_20185_() - shooter.m_20185_();
        double targetY = target.m_20186_() + (double)target.m_20192_() - shooter.m_20188_();
        double targetZ = target.m_20189_() - shooter.m_20189_();
        float speed = 1.15f;
        float inaccuracy = 2.0f;
        projectile.m_6034_(shooter.m_20185_(), shooter.m_20188_() - 0.2, shooter.m_20189_());
        Vec3 direction = new Vec3(targetX, targetY, targetZ).m_82541_().m_82490_((double)speed);
        projectile.m_20334_(direction.f_82479_ + shooter.m_217043_().m_188583_() * 0.0075 * (double)inaccuracy, direction.f_82480_ + shooter.m_217043_().m_188583_() * 0.0075 * (double)inaccuracy, direction.f_82481_ + shooter.m_217043_().m_188583_() * 0.0075 * (double)inaccuracy);
        shooter.m_9236_().m_7967_(projectile);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("CurrentProjectile", (Tag)this.currentProjectileStack.m_41739_(new CompoundTag()));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("CurrentProjectile", 10)) {
            this.currentProjectileStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("CurrentProjectile"));
        }
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        return null;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42398_);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 8.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.2);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 12.0);
        return builder;
    }
}

