/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import java.util.EnumSet;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class PygmadilloEntity
extends Monster {
    private int attackAnimationTick;
    private static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(PygmadilloEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public PygmadilloEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<PygmadilloEntity>)((EntityType)RedevModEntities.PYGMADILLO.get()), world);
    }

    public PygmadilloEntity(EntityType<PygmadilloEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.5f);
        this.f_21364_ = 30;
        this.m_21557_(false);
        this.m_6210_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new ChargeAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal((Mob)this));
    }

    private void breakSwordEfficientBlocks() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int radius = (int)Math.ceil(this.m_20205_());
        int height = (int)Math.ceil(this.m_20206_());
        for (int x = -radius; x <= radius; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    mutablePos.m_122190_((Vec3i)this.m_20183_().m_7918_(x, y, z));
                    BlockState state = this.m_9236_().m_8055_((BlockPos)mutablePos);
                    if (!state.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("sword_efficient")))) continue;
                    this.m_9236_().m_46961_((BlockPos)mutablePos, false);
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, (double)mutablePos.m_123341_() + 0.5, (double)mutablePos.m_123342_() + 0.5, (double)mutablePos.m_123343_() + 0.5, 3, 0.1, 0.1, 0.1, 0.02);
                }
            }
        }
    }

    public void spawnPoofParticles() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            double offsetX = (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
            double offsetY = this.f_19796_.m_188500_() * (double)this.m_20206_();
            double offsetZ = (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.01);
        }
    }

    public void m_7334_(Entity target) {
        if (this.getAttackState() == 2) {
            Vec3 motion = this.m_20184_();
            target.f_19802_ = 5;
            target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 4.0f);
            Vec3 knockback = new Vec3(motion.f_82479_ * 1.1, 0.015, motion.f_82481_ * 1.1);
            target.m_20256_(target.m_20184_().m_82549_(knockback));
        }
        super.m_7334_(target);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
    }

    public int getAttackState() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_STATE);
    }

    public void setAttackState(int state) {
        this.f_19804_.m_135381_(ATTACK_STATE, (Object)state);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getAttackState() == 2) {
            this.spawnSprintParticles();
            this.breakSwordEfficientBlocks();
        }
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    private void spawnSprintParticles() {
        if (this.m_9236_().f_46443_) {
            BlockPos blockPos = this.m_20183_().m_7495_();
            BlockState blockState = this.m_9236_().m_8055_(blockPos);
            if (!blockState.m_60795_()) {
                for (int i = 0; i < 5; ++i) {
                    double xOffset = (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
                    double zOffset = (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), this.m_20185_() + xOffset, this.m_20186_(), this.m_20189_() + zOffset, 0.0, 0.1, 0.0);
                }
            }
        }
    }

    public boolean m_7327_(Entity target) {
        this.attackAnimationTick = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        float attackDamage = (float)this.m_21133_(Attributes.f_22281_);
        boolean flag = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), attackDamage);
        if (flag) {
            this.m_19970_((LivingEntity)this, target);
        }
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.piglin_brute.hurt")), 1.0f, 1.0f);
        return flag;
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.attackAnimationTick = 10;
        } else {
            super.m_7822_(id);
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.piglin_brute.ambient"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.piglin_brute.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.piglin_brute.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.piglin_brute.death"));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268565_) || damagesource.m_276093_(DamageTypes.f_268448_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268714_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268526_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean m_6128_() {
        return true;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(1.2f);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)RedevModEntities.PYGMADILLO.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.m_217057_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 30.0);
        builder = builder.m_22268_(Attributes.f_22284_, 4.0);
        builder = builder.m_22268_(Attributes.f_22281_, 6.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.5);
        builder = builder.m_22268_(Attributes.f_22282_, 0.5);
        return builder;
    }

    public class ChargeAttackGoal
    extends Goal {
        private final PygmadilloEntity piggie;
        private LivingEntity target;
        private int chargeTime;
        private int cooldownTime;
        private Vec3 chargeDirection;

        public ChargeAttackGoal(PygmadilloEntity piggie) {
            this.piggie = piggie;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.piggie.getAttackState() != 0 || this.piggie.m_5448_() == null) {
                return false;
            }
            this.target = this.piggie.m_5448_();
            return (double)this.piggie.m_20270_((Entity)this.target) > 4.0;
        }

        public void m_8056_() {
            this.chargeTime = 15;
            this.cooldownTime = 0;
            this.piggie.setAttackState(1);
            this.piggie.m_21573_().m_26573_();
            this.piggie.m_21391_((Entity)this.target, 30.0f, 30.0f);
            Vec3 toTarget = this.target.m_20182_().m_82546_(this.piggie.m_20182_()).m_82541_();
            this.chargeDirection = new Vec3(toTarget.f_82479_, 0.0, toTarget.f_82481_);
        }

        public void m_8037_() {
            if (this.chargeTime > 0) {
                --this.chargeTime;
                this.piggie.m_21391_((Entity)this.target, 30.0f, 30.0f);
                if (this.piggie.m_20096_()) {
                    this.piggie.m_20256_(this.piggie.m_20184_().m_82520_(0.0, 0.4, 0.0));
                }
            } else if (this.chargeTime == 0) {
                this.piggie.setAttackState(2);
                Vec3 currentMotion = this.piggie.m_20184_();
                this.piggie.m_20256_(this.chargeDirection.m_82490_(1.15).m_82520_(0.0, currentMotion.f_82480_, 0.0));
                this.piggie.spawnPoofParticles();
                this.chargeTime = -1;
            } else if (this.chargeTime == -1) {
                if (this.cooldownTime < 6) {
                    ++this.cooldownTime;
                    Vec3 currentMotion = this.piggie.m_20184_();
                    this.piggie.m_20256_(this.chargeDirection.m_82490_(1.15).m_82520_(0.0, currentMotion.f_82480_, 0.0));
                } else {
                    this.piggie.setAttackState(0);
                    this.chargeTime = 0;
                }
            }
        }

        public void m_8041_() {
            this.piggie.setAttackState(0);
        }

        public boolean m_8045_() {
            return this.chargeTime != 0 || this.cooldownTime < 4;
        }
    }
}

