/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3f;

public class SkunkEntity
extends Animal {
    public SkunkEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<SkunkEntity>)((EntityType)RedevModEntities.SKUNK.get()), world);
    }

    public SkunkEntity(EntityType<SkunkEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 0;
        this.m_21557_(false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new FollowMobGoal((Mob)this, 1.0, 10.0f, 5.0f));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, Monster.class, 4.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(9, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50072_.m_5456_()}), false));
        this.f_21345_.m_25352_(10, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50073_.m_5456_()}), false));
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:skunk.ambient"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:skunk.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.fox.aggro"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.rabbit.death"));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        Entity attacker;
        if (!this.m_9236_().f_46443_ && (attacker = damagesource.m_7639_()) != null) {
            this.spraySkunkGas(attacker);
        }
        return super.m_6469_(damagesource, amount);
    }

    private void spraySkunkGas(Entity attacker) {
        ServerLevel world = (ServerLevel)this.m_9236_();
        double skunkX = this.m_20185_();
        double skunkY = this.m_20186_() + 0.5;
        double skunkZ = this.m_20189_();
        double dx = attacker.m_20185_() - skunkX;
        double dy = attacker.m_20186_() + (double)(attacker.m_20206_() / 2.0f) - skunkY;
        double dz = attacker.m_20189_() - skunkZ;
        double distance = Math.sqrt(dx * dx + dz * dz);
        if (distance != 0.0) {
            dx /= distance;
            dz /= distance;
        }
        int particleAmount = 15 + world.m_213780_().m_188503_(10);
        float r = 0.6313726f;
        float g = 0.96862745f;
        float b = 0.1254902f;
        float size = 1.5f;
        for (int i = 0; i < particleAmount; ++i) {
            double spread = 0.3;
            double velocityX = dx * 0.3 + (world.m_213780_().m_188500_() - 0.5) * spread;
            double velocityY = 0.2 + world.m_213780_().m_188500_() * 0.2;
            double velocityZ = dz * 0.3 + (world.m_213780_().m_188500_() - 0.5) * spread;
            world.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(r, g, b), size), skunkX, skunkY, skunkZ, 1, velocityX, velocityY, velocityZ, 0.0);
        }
        if (this.m_20280_(attacker) <= 4.0) {
            if (attacker instanceof Mob) {
                Mob mob = (Mob)attacker;
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 160, 0));
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 160, 2));
            } else if (attacker instanceof Player) {
                Player player = (Player)attacker;
                player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 160, 0));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 160, 2));
            }
        }
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        SkunkEntity retval = (SkunkEntity)((EntityType)RedevModEntities.SKUNK.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.f_50072_), new ItemStack((ItemLike)Blocks.f_50073_)}).test(stack);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)RedevModEntities.SKUNK.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_) && world.m_45524_(pos, 0) > 8);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 10.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }
}

